/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.utilitary.snippet;

import com.karuslabs.utilitary.snippet.AnnotationsSnippet;
import com.karuslabs.utilitary.snippet.Line;
import com.karuslabs.utilitary.snippet.Part;
import com.karuslabs.utilitary.snippet.Snippet;
import com.karuslabs.utilitary.snippet.TypeLine;
import java.util.TreeMap;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;

public class TypeSnippet
extends Snippet {
    public final AnnotationsSnippet annotations;
    public final Part<Modifier, Line> modifiers;
    public final TypeLine type;
    public final Line name;
    public final Part<TypeParameterElement, Line> typeParameters;
    public final Part<TypeMirror, Line> supertype;
    public final Part<TypeMirror, Line> interfaces;

    public static TypeSnippet of(TypeElement element, int column) {
        TreeMap<Integer, Line> lines = new TreeMap<Integer, Line>();
        AnnotationsSnippet annotations = AnnotationsSnippet.of(element.getAnnotationMirrors(), column);
        lines.putAll(annotations.lines);
        StringBuilder builder = new StringBuilder();
        column = annotations.last + 1;
        Part<Modifier, Line> modifiers = Part.modifiers(element.getModifiers(), column, builder.length());
        builder.append(modifiers);
        TypeLine type = TypeLine.of(element.getKind(), column, builder.length());
        builder.append(type).append(" ");
        Line name = new Line(element.getSimpleName().toString(), column, builder.length());
        builder.append(name);
        Part<TypeParameterElement, Line> typeParameters = Part.typeParameters(element.getTypeParameters(), column, builder.length());
        builder.append(typeParameters);
        Part<TypeMirror, Line> supertype = Part.extend(element.getSuperclass(), column, builder.length());
        builder.append(supertype);
        Part<TypeMirror, Line> interfaces = Part.implement(element.getKind(), element.getInterfaces(), column, builder.length());
        builder.append(interfaces).append(" {");
        lines.put(column, new Line(builder.toString(), column, 0));
        return new TypeSnippet(annotations, modifiers, type, name, typeParameters, supertype, interfaces, lines);
    }

    TypeSnippet(AnnotationsSnippet annotations, Part<Modifier, Line> modifiers, TypeLine type, Line name, Part<TypeParameterElement, Line> typeParameters, Part<TypeMirror, Line> supertype, Part<TypeMirror, Line> interfaces, TreeMap<Integer, Line> lines) {
        super(lines);
        this.annotations = annotations;
        this.modifiers = modifiers;
        this.type = type;
        this.name = name;
        this.typeParameters = typeParameters;
        this.supertype = supertype;
        this.interfaces = interfaces;
    }
}

