/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.utilitary;

import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Logger {
    private final Messager messager;
    private boolean error;

    public Logger(Messager messager) {
        this.messager = messager;
        this.error = false;
    }

    public void error(Element element, AnnotationMirror annotation, Object message) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, message.toString(), element, annotation);
        this.error = true;
    }

    public void error(@Nullable Element location, Object message) {
        this.print(location, Diagnostic.Kind.ERROR, message.toString());
        this.error = true;
    }

    public void warn(Element element, AnnotationMirror annotation, Object message) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, message.toString(), element, annotation);
    }

    public void warn(@Nullable Element location, String message) {
        this.print(location, Diagnostic.Kind.WARNING, message);
    }

    public void note(Element element, AnnotationMirror annotation, Object message) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, message.toString(), element, annotation);
    }

    public void note(@Nullable Element location, String message) {
        this.print(location, Diagnostic.Kind.NOTE, message);
    }

    private void print(@Nullable Element location, Diagnostic.Kind kind, String message) {
        if (location != null) {
            this.messager.printMessage(kind, message, location);
        } else {
            this.messager.printMessage(kind, message);
        }
    }

    public void clear() {
        this.error = false;
    }

    public boolean error() {
        return this.error;
    }
}

