/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.expression.node.impl;

import com.jfirer.jfireel.expression.node.CalculateNode;
import com.jfirer.jfireel.expression.node.MethodNode;
import com.jfirer.jfireel.expression.token.Token;
import com.jfirer.jfireel.expression.token.TokenType;
import java.lang.reflect.Method;
import java.util.Map;

public class ReflectMethodNode
implements MethodNode {
    private final CalculateNode beanNode;
    private final String methodName;
    private volatile Method method;
    private volatile Class<?> beanType;
    protected final boolean recognizeEveryTime;
    private CalculateNode[] argsNodes;
    private MethodNode.ConvertType[] convertTypes;
    private Token type;

    public ReflectMethodNode(String literals, CalculateNode beanNode, boolean recognizeEveryTime) {
        this.methodName = literals;
        this.type = Token.METHOD;
        this.beanNode = beanNode;
        this.recognizeEveryTime = recognizeEveryTime;
    }

    @Override
    public Object calculate(Map<String, Object> variables) {
        Object value = this.beanNode.calculate(variables);
        if (value == null) {
            return value;
        }
        Object[] args = new Object[this.argsNodes.length];
        try {
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.argsNodes[i].calculate(variables);
            }
            Method invoke = this.getMethod(value, args);
            MethodNode.MethodNodeUtil.convertArgs(args, this.convertTypes);
            return invoke.invoke(value, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public TokenType type() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getMethod(Object value, Object[] args) {
        if (this.recognizeEveryTime) {
            Method accessMethod = this.method;
            if (accessMethod == null || !this.beanType.isAssignableFrom(value.getClass())) {
                ReflectMethodNode reflectMethodNode = this;
                synchronized (reflectMethodNode) {
                    accessMethod = this.method;
                    if (accessMethod == null || !this.beanType.isAssignableFrom(value.getClass())) {
                        block6: for (Method each : value.getClass().getMethods()) {
                            if (!each.getName().equals(this.methodName) || each.getParameterTypes().length != args.length) continue;
                            Class<?>[] parameterTypes = each.getParameterTypes();
                            for (int i = 0; i < args.length; ++i) {
                                if (parameterTypes[i].isPrimitive() ? args[i] == null || !MethodNode.MethodNodeUtil.isWrapType(parameterTypes[i], args[i].getClass()) : args[i] != null && !parameterTypes[i].isAssignableFrom(args[i].getClass())) continue block6;
                            }
                            this.convertTypes = MethodNode.MethodNodeUtil.buildConvertTypes(parameterTypes);
                            accessMethod = each;
                            accessMethod.setAccessible(true);
                            this.beanType = value.getClass();
                            this.method = accessMethod;
                            return accessMethod;
                        }
                        throw new NullPointerException();
                    }
                }
            }
            return this.method;
        }
        if (this.method == null) {
            ReflectMethodNode reflectMethodNode = this;
            synchronized (reflectMethodNode) {
                if (this.method == null) {
                    Class<?> ckass = value.getClass();
                    block8: for (Method each : ckass.getMethods()) {
                        if (!each.getName().equals(this.methodName) || each.getParameterTypes().length != args.length) continue;
                        Class<?>[] parameterTypes = each.getParameterTypes();
                        for (int i = 0; i < args.length; ++i) {
                            if (parameterTypes[i].isPrimitive() ? args[i] == null || !MethodNode.MethodNodeUtil.isWrapType(parameterTypes[i], args[i].getClass()) : args[i] != null && !parameterTypes[i].isAssignableFrom(args[i].getClass())) continue block8;
                        }
                        this.convertTypes = MethodNode.MethodNodeUtil.buildConvertTypes(parameterTypes);
                        each.setAccessible(true);
                        this.method = each;
                        return this.method;
                    }
                }
                throw new NullPointerException();
            }
        }
        return this.method;
    }

    @Override
    public void setArgsNodes(CalculateNode[] argsNodes) {
        this.argsNodes = argsNodes;
        this.type = Token.METHOD_RESULT;
    }

    @Override
    public String literals() {
        StringBuilder cache = new StringBuilder();
        cache.append(this.beanNode.literals()).append('.').append(this.methodName).append('(');
        if (this.argsNodes != null) {
            for (CalculateNode each : this.argsNodes) {
                cache.append(each.literals()).append(',');
            }
            if (cache.charAt(cache.length() - 1) == ',') {
                cache.setLength(cache.length() - 1);
            }
        }
        cache.append(')');
        return cache.toString();
    }

    public String toString() {
        return this.literals();
    }
}

