/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.expression.node.impl;

import com.jfirer.jfireel.expression.node.CalculateNode;
import com.jfirer.jfireel.expression.token.Token;
import com.jfirer.jfireel.expression.token.TokenType;
import java.util.Map;

public class NumberNode
implements CalculateNode {
    private Number value;

    public NumberNode(String literals) {
        if (literals.indexOf(46) > -1) {
            this.value = Float.valueOf(literals);
            if (Float.isInfinite(((Float)this.value).floatValue())) {
                this.value = Double.valueOf(literals);
            }
        } else {
            try {
                this.value = Integer.valueOf(literals);
            }
            catch (NumberFormatException e) {
                this.value = Long.valueOf(literals);
            }
        }
    }

    @Override
    public Object calculate(Map<String, Object> variables) {
        return this.value;
    }

    @Override
    public TokenType type() {
        return Token.NUMBER;
    }

    @Override
    public String literals() {
        return this.value.toString();
    }

    public String toString() {
        return this.literals();
    }
}

