/*
 * Decompiled with CFR 0.152.
 */
package com.jfirer.jfireel.expression.node.impl;

import com.jfirer.baseutil.reflect.ReflectUtil;
import com.jfirer.baseutil.smc.SmcHelper;
import com.jfirer.baseutil.smc.compiler.CompileHelper;
import com.jfirer.baseutil.smc.model.ClassModel;
import com.jfirer.baseutil.smc.model.MethodModel;
import com.jfirer.jfireel.expression.node.CalculateNode;
import com.jfirer.jfireel.expression.node.MethodNode;
import com.jfirer.jfireel.expression.token.Token;
import com.jfirer.jfireel.expression.token.TokenType;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class CompileObjectMethodNode
implements MethodNode {
    private static final CompileHelper COMPILER = new CompileHelper();
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final CalculateNode beanNode;
    private final String methodName;
    private volatile Invoker invoker;
    private volatile Class<?> beanType;
    protected final boolean recognizeEveryTime;
    private CalculateNode[] argsNodes;
    private Token type;

    public CompileObjectMethodNode(String literals, CalculateNode beanNode, boolean recognizeEveryTime) {
        this.methodName = literals;
        this.type = Token.METHOD;
        this.beanNode = beanNode;
        this.recognizeEveryTime = recognizeEveryTime;
    }

    @Override
    public Object calculate(Map<String, Object> variables) {
        Object value = this.beanNode.calculate(variables);
        if (value == null) {
            return value;
        }
        Object[] args = new Object[this.argsNodes.length];
        try {
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.argsNodes[i].calculate(variables);
            }
            Invoker invoke = this.getMethod(value, args);
            return invoke.invoke(value, args);
        }
        catch (Exception e) {
            ReflectUtil.throwException((Throwable)e);
            return null;
        }
    }

    @Override
    public TokenType type() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Invoker getMethod(Object value, Object[] args) {
        if (this.recognizeEveryTime) {
            Invoker invoker = this.invoker;
            if (invoker == null || !this.beanType.isAssignableFrom(value.getClass())) {
                CompileObjectMethodNode compileObjectMethodNode = this;
                synchronized (compileObjectMethodNode) {
                    invoker = this.invoker;
                    if (invoker == null || !this.beanType.isAssignableFrom(value.getClass())) {
                        invoker = this.invoker = this.buildInvoker(value, args);
                        return invoker;
                    }
                }
            }
            return invoker;
        }
        if (this.invoker == null) {
            CompileObjectMethodNode compileObjectMethodNode = this;
            synchronized (compileObjectMethodNode) {
                if (this.invoker == null) {
                    this.invoker = this.buildInvoker(value, args);
                    return this.invoker;
                }
            }
        }
        return this.invoker;
    }

    private Invoker buildInvoker(Object value, Object[] args) {
        block0: for (Method each : value.getClass().getMethods()) {
            if (!each.getName().equals(this.methodName) || each.getParameterTypes().length != args.length) continue;
            Class<?>[] parameterTypes = each.getParameterTypes();
            for (int i = 0; i < args.length; ++i) {
                if (parameterTypes[i].isPrimitive() ? args[i] == null || !MethodNode.MethodNodeUtil.isWrapType(parameterTypes[i], args[i].getClass()) : args[i] != null && !parameterTypes[i].isAssignableFrom(args[i].getClass())) continue block0;
            }
            this.beanType = value.getClass();
            return this.buildInvoker(args, each);
        }
        ReflectUtil.throwException((Throwable)new NullPointerException());
        return null;
    }

    private Invoker buildInvoker(Object[] args, Method method) {
        try {
            ClassModel classModel = new ClassModel("Invoke_" + method.getName() + "_" + counter.incrementAndGet(), Object.class, new Class[]{Invoker.class});
            MethodModel methodModel = new MethodModel(classModel);
            methodModel.setAccessLevel(MethodModel.AccessLevel.PUBLIC);
            methodModel.setMethodName("invoke");
            methodModel.setParamterTypes(new Class[]{Object.class, Object[].class});
            methodModel.setReturnType(Object.class);
            StringBuilder body = new StringBuilder(" return ((" + SmcHelper.getReferenceName(method.getDeclaringClass(), (ClassModel)classModel) + ")$0)." + method.getName() + "(");
            int length = body.length();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> parameterType = parameterTypes[i];
                if (parameterType == Integer.TYPE) {
                    body.append("((java.lang.Number)$1[").append(i).append("]).intValue(),");
                    continue;
                }
                if (parameterType == Integer.class) {
                    if (args[i].getClass() == Integer.class) {
                        body.append("((java.lang.Integer)$").append(i).append("),");
                        continue;
                    }
                    body.append("((java.lang.Number)$1[").append(i).append("]).intValue(),");
                    continue;
                }
                if (parameterTypes[i] == Short.TYPE || parameterTypes[i] == Short.TYPE) {
                    body.append("((java.lang.Number)$1[").append(i).append("]).shortValue(),");
                    continue;
                }
                if (parameterTypes[i] == Long.TYPE) {
                    body.append("((java.lang.Number)$1[").append(i).append("]).longValue(),");
                    continue;
                }
                if (parameterType == Long.class) {
                    if (args[i].getClass() == Long.class) {
                        body.append("((java.lang.Long)$").append(i).append("),");
                        continue;
                    }
                    body.append("((java.lang.Number)$1[").append(i).append("]).longValue(),");
                    continue;
                }
                if (parameterTypes[i] == Float.TYPE) {
                    body.append("((java.lang.Number)$1[").append(i).append("]).floatValue(),");
                    continue;
                }
                if (parameterType == Float.class) {
                    if (args[i].getClass() == Float.class) {
                        body.append("((java.lang.Float)$").append(i).append("),");
                        continue;
                    }
                    body.append("((java.lang.Number)$1[").append(i).append("]).floatValue(),");
                    continue;
                }
                if (parameterTypes[i] == Double.TYPE) {
                    body.append("((java.lang.Number)$1[").append(i).append("]).doubleValue(),");
                    continue;
                }
                if (parameterType == Double.class) {
                    body.append("((java.lang.Double)$").append(i).append("),");
                    continue;
                }
                if (parameterTypes[i] == Byte.TYPE || parameterTypes[i] == Byte.class) {
                    body.append("((java.lang.Number)$1[").append(i).append("]).byteValue(),");
                    continue;
                }
                if (parameterTypes[i] == Boolean.TYPE) {
                    body.append("((java.lang.Boolean)$1[").append(i).append("]).booleanValue(),");
                    continue;
                }
                if (parameterType == Boolean.class) {
                    body.append("((java.lang.Boolean)$").append(i).append("),");
                    continue;
                }
                body.append("((" + SmcHelper.getReferenceName(parameterTypes[i], (ClassModel)classModel) + ")$1[").append(i).append("]),");
            }
            if (body.length() != length) {
                body.setLength(body.length() - 1);
            }
            body.append(");");
            methodModel.setBody(body.toString());
            classModel.putMethodModel(methodModel);
            Class compile = COMPILER.compile(classModel);
            return (Invoker)compile.newInstance();
        }
        catch (Exception e) {
            ReflectUtil.throwException((Throwable)e);
            return null;
        }
    }

    @Override
    public void setArgsNodes(CalculateNode[] argsNodes) {
        this.argsNodes = argsNodes;
        this.type = Token.METHOD_RESULT;
    }

    @Override
    public String literals() {
        StringBuilder cache = new StringBuilder();
        cache.append(this.beanNode.literals()).append('.').append(this.methodName).append('(');
        if (this.argsNodes != null) {
            for (CalculateNode each : this.argsNodes) {
                cache.append(each.literals()).append(',');
            }
            if (cache.charAt(cache.length() - 1) == ',') {
                cache.setLength(cache.length() - 1);
            }
        }
        cache.append(')');
        return cache.toString();
    }

    public String toString() {
        return this.literals();
    }

    public static interface Invoker {
        public Object invoke(Object var1, Object[] var2);
    }
}

