/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.AccessTokenApi;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BlackUserApi {
    private static String getBlackList = "https://api.weixin.qq.com/cgi-bin/tags/members/getblacklist?access_token=";
    private static String batchBlackList = "https://api.weixin.qq.com/cgi-bin/tags/members/batchblacklist?access_token=";
    private static String batchUnblackList = "https://api.weixin.qq.com/cgi-bin/tags/members/batchunblacklist?access_token=";

    public static ApiResult getBlackList(String beginOpenid) {
        String url = getBlackList + AccessTokenApi.getAccessTokenStr();
        HashMap<String, String> mapData = new HashMap<String, String>();
        if (StrKit.notBlank((String)beginOpenid)) {
            mapData.put("begin_openid", beginOpenid);
        }
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(mapData));
        return new ApiResult(jsonResult);
    }

    public static ApiResult getBlackList() {
        return BlackUserApi.getBlackList(null);
    }

    public static ApiResult batchBlackUsers(String jsonStr) {
        String jsonResult = HttpUtils.post(batchBlackList + AccessTokenApi.getAccessTokenStr(), jsonStr);
        return new ApiResult(jsonResult);
    }

    public static ApiResult batchBlackUsers(List<String> openIdList) throws IllegalArgumentException {
        if (openIdList == null) {
            throw new IllegalArgumentException();
        }
        HashMap userListMap = new HashMap();
        ArrayList<String> userList = new ArrayList<String>();
        if (openIdList != null && openIdList.size() > 0) {
            for (String openId : openIdList) {
                userList.add(openId);
            }
        }
        userListMap.put("opened_list", userList);
        return BlackUserApi.batchBlackUsers(JsonUtils.toJson(userListMap));
    }

    public static ApiResult batchUnblackUsers(String jsonStr) {
        String jsonResult = HttpUtils.post(batchUnblackList + AccessTokenApi.getAccessTokenStr(), jsonStr);
        return new ApiResult(jsonResult);
    }

    public static ApiResult batchUnblackUsers(List<String> openIdList) throws IllegalArgumentException {
        if (openIdList == null) {
            throw new IllegalArgumentException();
        }
        HashMap userListMap = new HashMap();
        ArrayList<String> userList = new ArrayList<String>();
        if (openIdList != null && openIdList.size() > 0) {
            for (String openId : openIdList) {
                userList.add(openId);
            }
        }
        userListMap.put("opened_list", userList);
        return BlackUserApi.batchUnblackUsers(JsonUtils.toJson(userListMap));
    }
}

