/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.utils;

import com.jfinal.weixin.sdk.utils.Charsets;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;

public class Base64Utils {
    private Base64Utils() {
    }

    public static String encode(byte[] value) {
        return DatatypeConverter.printBase64Binary((byte[])value);
    }

    public static String encode(String value) {
        byte[] val = value.getBytes(Charsets.UTF_8);
        return Base64Utils.encode(val);
    }

    public static String encode(String value, String charsetName) {
        byte[] val = value.getBytes(Charset.forName(charsetName));
        return Base64Utils.encode(val);
    }

    public static byte[] decodeBase64(String value) {
        return DatatypeConverter.parseBase64Binary((String)value);
    }

    public static String decode(String value) {
        byte[] decodedValue = Base64Utils.decodeBase64(value);
        return new String(decodedValue, Charsets.UTF_8);
    }

    public static String decode(String value, String charsetName) {
        byte[] decodedValue = Base64Utils.decodeBase64(value);
        return new String(decodedValue, Charset.forName(charsetName));
    }
}

