/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.weixin.sdk.api.AccessToken;
import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.cache.IAccessTokenCache;
import com.jfinal.weixin.sdk.kit.ParaMap;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.RetryUtils;
import java.util.Map;
import java.util.concurrent.Callable;

public class AccessTokenApi {
    private static String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential";
    static IAccessTokenCache accessTokenCache = ApiConfigKit.getAccessTokenCache();

    public static AccessToken getAccessToken() {
        String appId = ApiConfigKit.getApiConfig().getAppId();
        AccessToken result = (AccessToken)accessTokenCache.get(appId);
        if (result != null && result.isAvailable()) {
            return result;
        }
        AccessTokenApi.refreshAccessToken();
        return (AccessToken)accessTokenCache.get(appId);
    }

    public static String getAccessTokenStr() {
        return AccessTokenApi.getAccessToken().getAccessToken();
    }

    public static synchronized void refreshAccessToken() {
        ApiConfig ac = ApiConfigKit.getApiConfig();
        String appId = ac.getAppId();
        String appSecret = ac.getAppSecret();
        final Map<String, String> queryParas = ParaMap.create("appid", appId).put("secret", appSecret).getData();
        AccessToken result = RetryUtils.retryOnException(3, new Callable<AccessToken>(){

            @Override
            public AccessToken call() throws Exception {
                String json = HttpUtils.get(url, queryParas);
                return new AccessToken(json);
            }
        });
        accessTokenCache.set(ac.getAppId(), result);
    }
}

