/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow;

import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.IOException;
import java.util.ArrayList;

public class CompositeResourceManager
implements ResourceManager {
    protected ResourceManager[] resourceManagers = new ResourceManager[0];

    public boolean isEmpty() {
        return this.resourceManagers.length == 0;
    }

    public void add(ResourceManager resourceManager) {
        ArrayList<ResourceManager> list = new ArrayList<ResourceManager>();
        for (ResourceManager rm : this.resourceManagers) {
            list.add(rm);
        }
        list.add(resourceManager);
        this.resourceManagers = list.toArray(new ResourceManager[list.size()]);
    }

    public Resource getResource(String path) throws IOException {
        for (ResourceManager rm : this.resourceManagers) {
            Resource ret = rm.getResource(path);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public boolean isResourceChangeListenerSupported() {
        for (ResourceManager rm : this.resourceManagers) {
            if (!rm.isResourceChangeListenerSupported()) continue;
            return true;
        }
        return false;
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
        for (ResourceManager rm : this.resourceManagers) {
            if (!rm.isResourceChangeListenerSupported()) continue;
            rm.registerResourceChangeListener(listener);
        }
    }

    public void removeResourceChangeListener(ResourceChangeListener resourceChangeListener) {
        for (ResourceManager rm : this.resourceManagers) {
            if (!rm.isResourceChangeListenerSupported()) continue;
            rm.removeResourceChangeListener(resourceChangeListener);
        }
    }

    public void close() throws IOException {
        for (ResourceManager rm : this.resourceManagers) {
            rm.close();
        }
    }
}

