/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.log;

import com.jfinal.ext2.log.ILogFactoryExt;
import com.jfinal.ext2.log.JdkLogFactoryExt;

public abstract class Logger {
    private static ILogFactoryExt factory;

    static void init() {
        if (factory == null) {
            try {
                Class.forName("org.apache.log4j.Logger");
                Class<?> log4jLogFactoryExtClass = Class.forName("com.jfinal.ext2.log.Log4jLogFactoryExt");
                factory = (ILogFactoryExt)log4jLogFactoryExtClass.newInstance();
            }
            catch (Exception e) {
                factory = new JdkLogFactoryExt();
            }
        }
    }

    public static void setLoggerFactory(ILogFactoryExt loggerFactory) {
        if (loggerFactory != null) {
            factory = loggerFactory;
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        return factory.getLogger(clazz);
    }

    public static Logger getLogger(String name) {
        return factory.getLogger(name);
    }

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void info(String var1);

    public abstract void info(String var1, Throwable var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, Throwable var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract void fatal(String var1);

    public abstract void fatal(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isFatalEnabled();

    static {
        Logger.init();
    }
}

