/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext2.plugin.redis;

import com.jfinal.ext2.plugin.redis.ShardCache;
import com.jfinal.ext2.plugin.redis.ShardRedis;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.redis.IKeyNamingPolicy;
import com.jfinal.plugin.redis.serializer.FstSerializer;
import com.jfinal.plugin.redis.serializer.ISerializer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedisPool;

public class ShardRedisPlugin
implements IPlugin {
    private List<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
    private ISerializer serializer = null;
    private IKeyNamingPolicy keyNamingPolicy = null;
    private JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();

    public ShardRedisPlugin(List<JedisShardInfo> shards) {
        this.shards = shards;
    }

    public boolean addShard(JedisShardInfo shard) {
        if (shard == null) {
            throw new IllegalArgumentException("want add a null shard");
        }
        for (JedisShardInfo jedisShardInfo : this.shards) {
            if (!jedisShardInfo.getHost().equals(shard.getHost()) || jedisShardInfo.getPort() != shard.getPort()) continue;
            return true;
        }
        return this.shards.add(shard);
    }

    public boolean start() {
        ShardedJedisPool jedisPool = new ShardedJedisPool((GenericObjectPoolConfig)this.jedisPoolConfig, this.shards);
        if (this.serializer == null) {
            this.serializer = FstSerializer.me;
        }
        if (this.keyNamingPolicy == null) {
            this.keyNamingPolicy = IKeyNamingPolicy.defaultKeyNamingPolicy;
        }
        ShardCache cache = new ShardCache(jedisPool, this.serializer, this.keyNamingPolicy);
        ShardRedis.setShardCache(cache);
        return true;
    }

    public boolean stop() {
        ShardRedis.shardCache.jedisPool.destroy();
        return true;
    }

    public JedisPoolConfig getJedisPoolConfig() {
        return this.jedisPoolConfig;
    }

    public void setSerializer(ISerializer serializer) {
        this.serializer = serializer;
    }

    public void setKeyNamingPolicy(IKeyNamingPolicy keyNamingPolicy) {
        this.keyNamingPolicy = keyNamingPolicy;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.jedisPoolConfig.setTestWhileIdle(testWhileIdle);
    }

    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.jedisPoolConfig.setMinEvictableIdleTimeMillis((long)minEvictableIdleTimeMillis);
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.jedisPoolConfig.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictionRunsMillis);
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.jedisPoolConfig.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }
}

