/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext2.plugin.activerecord.generator;

import com.jfinal.plugin.activerecord.generator.MappingKitGenerator;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import java.util.List;

public class MappingKitGeneratorExt
extends MappingKitGenerator {
    private boolean generateMappingArpKit = true;
    private boolean generateTableMapping = true;
    protected String tableMappingPutTableTemplate = "\tpublic void putTable(Class<? extends Model<?>> modelClass, String tableName) {%n\t\tthis.modelToTableMap.put(modelClass, tableName);\n\t}\n\tpublic void putTable(String tableName, Class<? extends Model<?>> modelClass) {%n\t\tthis.tableToModelMap.put(tableName, modelClass);\n\t}\n";
    protected String tableMappingGetTableTemplate = "\n\tpublic String getTableName(Class<? extends Model<?>> modelClass) {%n\t\tif (!this.modelToTableMap.containsKey(modelClass)) {\n\t\t\treturn \"\";\n\t\t}\n\t\treturn this.modelToTableMap.get(modelClass);\n\t}\n\n\tpublic Class<? extends Model<?>> getModelClass(String tableName) {%n\t\tif (!this.tableToModelMap.containsKey(tableName)) {\n\t\t\treturn null;\n\t\t}\n\t\treturn this.tableToModelMap.get(tableName);\n\t}\n";
    protected String tableMappingTemplate = "\tprivate final Map<Class<? extends Model<?>>, String> modelToTableMap = new HashMap<Class<? extends Model<?>>, String>();\n\tprivate final Map<String, Class<? extends Model<?>>> tableToModelMap = new HashMap<String, Class<? extends Model<?>>>();\n\tprivate static %s me = new %s();\n\n";
    protected String tableMappingMethodTemplate = "\tpublic static %s me() {\n\t\treturn me;\n\t}\n\n";
    protected String tableMappingMethodContentTemplate = "\t\tthis.modelToTableMap.put(%s.class, \"%s\");%n\t\tthis.tableToModelMap.put(\"%s\", %s.class);%n";

    public MappingKitGeneratorExt(String mappingKitPackageName, String mappingKitOutputDir) {
        super(mappingKitPackageName, mappingKitOutputDir);
    }

    public void setMappingKitClassName(String mappingKitClassName) {
        this.mappingKitClassName = mappingKitClassName;
    }

    public void setGenerateMappingArpKit(boolean generateMappingArpKit) {
        this.generateMappingArpKit = generateMappingArpKit;
    }

    public void setGenerateTableMapping(boolean generateTableMapping) {
        this.generateTableMapping = generateTableMapping;
    }

    protected void genClassDefine(StringBuilder ret) {
        if (this.generateTableMapping) {
            this.classDefineTemplate = "/**%n * Generated by JFinal-Ext2.%n */%npublic class %s {%n%n";
        }
        super.genClassDefine(ret);
        if (this.generateTableMapping) {
            ret.append(String.format(this.tableMappingTemplate, this.mappingKitClassName, this.mappingKitClassName));
            ret.append(String.format(this.tableMappingMethodTemplate, this.mappingKitClassName));
        }
    }

    protected void genImport(StringBuilder ret) {
        if (this.generateMappingArpKit) {
            super.genImport(ret);
        }
        if (this.generateTableMapping) {
            ret.append("import java.util.*;\nimport com.jfinal.plugin.activerecord.Model;\n\n");
        }
    }

    protected void genMappingMethod(List<TableMeta> tableMetas, StringBuilder ret) {
        if (this.generateMappingArpKit) {
            super.genMappingMethod(tableMetas, ret);
            ret.append("\n");
        }
        if (this.generateTableMapping) {
            ret.append(String.format(this.tableMappingPutTableTemplate, new Object[0]));
            ret.append(String.format(this.tableMappingGetTableTemplate, new Object[0]));
            ret.append(String.format("\n\tprivate %s() {\n", this.mappingKitClassName));
            for (TableMeta tableMeta : tableMetas) {
                ret.append(String.format(this.tableMappingMethodContentTemplate, tableMeta.modelName, tableMeta.name, tableMeta.name, tableMeta.modelName));
            }
            ret.append("\t}\n");
        }
    }
}

