/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext2.plugin.activerecord.generator;

import com.jfinal.plugin.activerecord.generator.BaseModelGenerator;
import com.jfinal.plugin.activerecord.generator.ColumnMeta;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import java.util.ArrayList;
import java.util.List;

public class BaseModelGeneratorExt
extends BaseModelGenerator {
    private List<String> columns = new ArrayList<String>();
    private List<String> modelClass = new ArrayList<String>();
    protected String baseModelClassName = null;
    protected String tablename = null;
    protected String tableTemplate = "\tpublic static final String table = \"%s\";\n\n";
    private boolean generateTableNameInModel = true;
    private boolean generateTableColumnNameInModel = true;
    protected String tableColumnNameTemplate = "\tpublic static final String %s = \"%s\";\n\n";

    public BaseModelGeneratorExt(String baseModelPackageName, String baseModelOutputDir) {
        super(baseModelPackageName, baseModelOutputDir);
    }

    public void setGenerateTableNameInModel(boolean generateTableNameInModel) {
        this.generateTableNameInModel = generateTableNameInModel;
    }

    public void setGenerateTableColumnNameInModel(boolean generateTableColumnNameInModel) {
        this.generateTableColumnNameInModel = generateTableColumnNameInModel;
    }

    protected void genBaseModelContent(TableMeta tableMeta) {
        this.baseModelClassName = tableMeta.baseModelName;
        this.tablename = tableMeta.name;
        super.genBaseModelContent(tableMeta);
    }

    protected void genSetMethodName(ColumnMeta columnMeta, StringBuilder ret) {
        if (!this.modelClass.contains(this.baseModelClassName) && this.generateTableNameInModel) {
            this.modelClass.add(this.baseModelClassName);
            ret.append(String.format(this.tableTemplate, this.tablename));
        }
        if (this.generateTableColumnNameInModel && !this.columns.contains(this.tablename + columnMeta.name)) {
            this.columns.add(this.tablename + columnMeta.name);
            ret.append(String.format(this.tableColumnNameTemplate, columnMeta.name.toUpperCase(), columnMeta.name));
        }
        super.genSetMethodName(columnMeta, ret);
    }
}

