/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext2.kit;

public final class PageViewKit {
    public static final String WEBINF_DIR = "/WEB-INF/";
    public static final String ROOT_DIR = "/";
    public static final String JSP = ".jsp";
    public static final String HTML = ".html";
    private static final String ERROR_PAGE_PATH = "errorpages/";
    private static final String PAGE_VIEW_PATH = "pageviews/";

    public static String get404PageView() {
        return PageViewKit.getErrorCodePageView("404");
    }

    public static String get403PageView() {
        return PageViewKit.getErrorCodePageView("403");
    }

    public static String get500PageView() {
        return PageViewKit.getErrorCodePageView("500");
    }

    private static String getErrorCodePageView(String errorCode) {
        return PageViewKit.getPageView(WEBINF_DIR, ERROR_PAGE_PATH, errorCode, JSP);
    }

    public static String getJSPPageViewFromWebInf(String pageName) {
        return PageViewKit.getPageView(WEBINF_DIR, PAGE_VIEW_PATH, pageName, JSP);
    }

    public static String getJSPPageViewFromWebInf(String pathRefRootViews, String pageName) {
        return PageViewKit.getPageView(WEBINF_DIR, PAGE_VIEW_PATH + pathRefRootViews, pageName, JSP);
    }

    public static String getJSPPageViewFromRoot(String pageName) {
        return PageViewKit.getPageView(ROOT_DIR, PAGE_VIEW_PATH, pageName, JSP);
    }

    public static String getJSPPageViewFromRoot(String pathRefRootViews, String pageName) {
        return PageViewKit.getPageView(ROOT_DIR, PAGE_VIEW_PATH + pathRefRootViews, pageName, JSP);
    }

    public static String getHTMLPageViewFromWebInf(String pageName) {
        return PageViewKit.getPageView(WEBINF_DIR, PAGE_VIEW_PATH, pageName, HTML);
    }

    public static String getHTMLPageViewFromWebInf(String pathRefRootViews, String pageName) {
        return PageViewKit.getPageView(WEBINF_DIR, PAGE_VIEW_PATH + pathRefRootViews, pageName, HTML);
    }

    public static String getHTMLPageViewFromRoot(String pageName) {
        return PageViewKit.getHTMLPageView(ROOT_DIR, PAGE_VIEW_PATH, pageName);
    }

    public static String getHTMLPageViewFromRoot(String pathRefRootViews, String pageName) {
        return PageViewKit.getHTMLPageView(ROOT_DIR, PAGE_VIEW_PATH + pathRefRootViews, pageName);
    }

    public static String getHTMLPageView(String dir, String viewPath, String pageName) {
        return PageViewKit.getPageView(dir, viewPath, pageName, HTML);
    }

    public static String getJSPPageView(String dir, String viewPath, String pageName) {
        return PageViewKit.getPageView(dir, viewPath, pageName, JSP);
    }

    public static String getPageView(String dir, String viewPath, String pageName, String fileExtension) {
        if (!dir.endsWith(ROOT_DIR)) {
            dir = dir + ROOT_DIR;
        }
        if (!viewPath.endsWith(ROOT_DIR)) {
            viewPath = viewPath + ROOT_DIR;
        }
        return dir + viewPath + pageName + fileExtension;
    }
}

