/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext2.kit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class DDLKit {
    public static final String BIGINT = "bigint";
    public static final String VARCHAR = "varchar";
    public static final String TEXT = "text";
    public static final String INT = "int";
    public static final String TINYINT = "tinyint";

    public static Table createTable(String tableName, String comment) {
        return new Table(tableName, comment);
    }

    public static class Column {
        private String columnName = null;
        private String columnType = null;
        private int columnSize = 10;
        private StringBuilder defaultValue = new StringBuilder();
        private String comment = null;
        private boolean primaryKey = false;
        private boolean uniqueKey = false;

        public Column(String columnName, String columnType, String comment, int columnSize, String defaultValue, boolean primaryKey, boolean uniqueKey) {
            if (!columnName.startsWith("`")) {
                columnName = "`" + columnName;
            }
            if (!columnName.endsWith("`")) {
                columnName = columnName + "`";
            }
            this.columnName = columnName;
            this.columnType = columnType;
            if (null == defaultValue) {
                this.defaultValue.append("DEFAULT NULL");
            } else {
                String value = "".equals(defaultValue) || "''".equals(defaultValue) ? "''" : "'" + defaultValue + "'";
                this.defaultValue.append("NOT NULL DEFAULT ").append(value);
            }
            if (!comment.startsWith("'")) {
                comment = "'" + comment;
            }
            if (!comment.endsWith("'")) {
                comment = comment + "'";
            }
            this.comment = comment;
            this.columnSize = columnSize;
            this.primaryKey = primaryKey;
            this.uniqueKey = uniqueKey;
        }

        public Column primaryKeyColumn(String columnName, String columnType, String comment, int columnSize, String defalutValue) {
            return new Column(columnName, columnType, comment, columnSize, defalutValue, true, false);
        }

        public Column uniqueKeyColumn(String columnName, String columnType, String comment, int columnSize, String defalutValue) {
            return new Column(columnName, columnType, comment, columnSize, defalutValue, false, true);
        }

        public String ddl() {
            return this.columnName + " " + this.columnType + "(" + this.columnSize + ") " + this.defaultValue + " COMMENT " + this.comment;
        }
    }

    public static class Table {
        private String tableName = null;
        private String comment = null;
        HashMap<String, Column> columnsMap = new HashMap();
        private List<Column> primaryKeys = new ArrayList<Column>();
        private List<Column> uniqueKeys = new ArrayList<Column>();

        private Table(String tableName, String comment) {
            this.tableName = tableName;
            if (!comment.startsWith("`")) {
                comment = "'" + comment;
            }
            if (!comment.endsWith("`")) {
                comment = comment + "'";
            }
            this.comment = comment;
        }

        public Table addColumn(Column column) {
            if (null == column) {
                return this;
            }
            if (!this.columnsMap.containsKey(column.columnName)) {
                this.columnsMap.put(column.columnName, column);
            }
            if (column.primaryKey) {
                this.primaryKeys.add(column);
            }
            if (column.uniqueKey) {
                this.uniqueKeys.add(column);
            }
            return this;
        }

        public Table addColumns(List<Column> columns) {
            if (null == columns) {
                return this;
            }
            for (Column column : columns) {
                this.addColumn(column);
            }
            return this;
        }

        public String ddl() {
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("CREATE TABLE `").append(this.tableName).append("` (\n");
            sqlBuilder.append("`id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '\u7d22\u5f15',\n");
            for (String key : this.columnsMap.keySet()) {
                sqlBuilder.append(this.columnsMap.get(key).ddl()).append(",\n");
            }
            sqlBuilder.append("PRIMARY KEY (`id`");
            for (Column column : this.primaryKeys) {
                sqlBuilder.append(",").append(column.columnName);
            }
            sqlBuilder.append(")");
            for (Column column : this.uniqueKeys) {
                sqlBuilder.append(",\nUNIQUE KEY").append(column.columnName).append("(").append(column.columnName).append(")");
            }
            sqlBuilder.append("\n) COMMENT=").append(this.comment).append(";");
            return sqlBuilder.toString();
        }
    }
}

