/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext2.config;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.wall.WallFilter;
import com.jfinal.aop.Interceptor;
import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.JFinalConfig;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.ext.interceptor.POST;
import com.jfinal.ext.route.AutoBindRoutes;
import com.jfinal.ext2.handler.ActionExtentionHandler;
import com.jfinal.ext2.interceptor.NotFoundActionInterceptor;
import com.jfinal.ext2.interceptor.OnExceptionInterceptorExt;
import com.jfinal.ext2.kit.PageViewKit;
import com.jfinal.ext2.plugin.activerecord.generator.BaseModelGeneratorExt;
import com.jfinal.ext2.plugin.activerecord.generator.MappingKitGeneratorExt;
import com.jfinal.ext2.plugin.druid.DruidEncryptPlugin;
import com.jfinal.ext2.upload.filerenamepolicy.RandomFileRenamePolicy;
import com.jfinal.handler.Handler;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.IDataSourceProvider;
import com.jfinal.plugin.activerecord.generator.BaseModelGenerator;
import com.jfinal.plugin.activerecord.generator.Generator;
import com.jfinal.plugin.activerecord.generator.MappingKitGenerator;
import com.jfinal.plugin.activerecord.generator.ModelGenerator;
import com.jfinal.plugin.druid.DruidPlugin;
import com.jfinal.render.ViewType;
import com.jfinal.upload.OreillyCos;
import com.oreilly.servlet.multipart.FileRenamePolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class JFinalConfigExt
extends JFinalConfig {
    private static final String cfg = "cfg.txt";
    public static String APP_NAME = null;
    protected boolean geRuned = false;
    private static final String ACTIVE_TEMPLATE = "db.%s.active";
    private static final String URL_TEMPLATE = "jdbc:%s://%s";
    private static final String USER_TEMPLATE = "db.%s.user";
    private static final String PASSWORD_TEMPLATE = "db.%s.password";
    private static final String INITSIZE_TEMPLATE = "db.%s.initsize";
    private static final String MAXSIZE_TEMPLATE = "db.%s.maxactive";
    private Boolean geDaoInModel = null;
    private Boolean geTableNameInModel = null;
    private static final String DEFAULT_MAPPINGKIT_CLASS_NAME = "_MappingKit";
    private String mappingKitClassName = null;

    public abstract void configMoreConstants(Constants var1);

    public abstract void configMoreRoutes(Routes var1);

    public abstract void configMorePlugins(Plugins var1);

    public abstract void configTablesMapping(String var1, ActiveRecordPlugin var2);

    public abstract void configMoreInterceptors(Interceptors var1);

    public abstract void configMoreHandlers(Handlers var1);

    public abstract void afterJFinalStarted();

    public void configConstant(Constants me) {
        me.setViewType(ViewType.JSP);
        me.setDevMode(this.getAppDevMode());
        me.setEncoding("UTF-8");
        me.setError404View(PageViewKit.get404PageView());
        me.setError500View(PageViewKit.get500PageView());
        me.setError403View(PageViewKit.get403PageView());
        me.setBaseUploadPath(this.getUploadPath());
        me.setBaseDownloadPath(this.getDownloadPath());
        APP_NAME = this.getAppName();
        OreillyCos.setFileRenamePolicy((FileRenamePolicy)new RandomFileRenamePolicy());
        this.configMoreConstants(me);
    }

    public void configRoute(Routes me) {
        me.add((Routes)new AutoBindRoutes());
        this.configMoreRoutes(me);
    }

    public void configPlugin(Plugins me) {
        String[] dses;
        for (String ds : dses = this.getDataSource()) {
            if (!this.getDbActiveState(ds)) continue;
            DruidEncryptPlugin drp = this.getDruidPlugin(ds);
            me.add((IPlugin)drp);
            ActiveRecordPlugin arp = this.getActiveRecordPlugin(ds, drp);
            me.add((IPlugin)arp);
            this.configTablesMapping(ds, arp);
        }
        this.configMorePlugins(me);
    }

    public void configInterceptor(Interceptors me) {
        me.add((Interceptor)new NotFoundActionInterceptor());
        me.add((Interceptor)new OnExceptionInterceptorExt());
        if (this.getHttpPostMethod()) {
            me.add((Interceptor)new POST());
        }
        this.configMoreInterceptors(me);
    }

    public void configHandler(Handlers me) {
        me.add((Handler)new ActionExtentionHandler());
        this.configMoreHandlers(me);
    }

    public void afterJFinalStart() {
        super.afterJFinalStart();
        this.afterJFinalStarted();
    }

    private void loadPropertyFile() {
        if (this.prop == null) {
            this.loadPropertyFile(cfg);
        }
    }

    private boolean getHttpPostMethod() {
        this.loadPropertyFile();
        return this.getPropertyToBoolean("app.post", false);
    }

    private String getPath(String property) {
        if (StrKit.isBlank((String)property) || !"downloads".equals(property) && !"uploads".equals(property)) {
            throw new IllegalArgumentException("property is invalid, property just use `downloads` or `uploads`");
        }
        this.loadPropertyFile();
        String app = this.getAppName();
        String baseDir = this.getProperty(String.format("app.%s.basedir", property));
        if (baseDir.endsWith("/")) {
            if (!baseDir.endsWith(property + "/")) {
                baseDir = baseDir + property + "/";
            }
        } else {
            baseDir = !baseDir.endsWith(property) ? baseDir + "/" + property + "/" : baseDir + "/";
        }
        return baseDir + app;
    }

    private String getUploadPath() {
        return this.getPath("uploads");
    }

    private String getDownloadPath() {
        return this.getPath("downloads");
    }

    private boolean getAppDevMode() {
        this.loadPropertyFile();
        return this.getPropertyToBoolean("app.dev", true);
    }

    private String getAppName() {
        this.loadPropertyFile();
        String appName = this.getProperty("app.name", "");
        if (StrKit.isBlank((String)appName)) {
            throw new IllegalArgumentException("Please Set Your App Name in Your cfg file");
        }
        return appName;
    }

    private boolean getDbActiveState(String ds) {
        this.loadPropertyFile();
        return this.getPropertyToBoolean(String.format(ACTIVE_TEMPLATE, ds), false);
    }

    private String[] getDataSource() {
        this.loadPropertyFile();
        String ds = this.getProperty("db.ds", "");
        if (StrKit.isBlank((String)ds)) {
            return new String[0];
        }
        if (ds.contains("\uff0c")) {
            new IllegalArgumentException("Cannot use \uff0cin ds");
        }
        return ds.split(",");
    }

    private DruidEncryptPlugin getDruidPlugin(String ds) {
        this.loadPropertyFile();
        String url = this.getProperty(String.format("db.%s.url", ds));
        url = String.format(URL_TEMPLATE, ds, url);
        String endsWith = "?characterEncoding=UTF8&zeroDateTimeBehavior=convertToNull";
        if (!url.endsWith(endsWith)) {
            url = url + endsWith;
        }
        DruidEncryptPlugin dp = new DruidEncryptPlugin(url, this.getProperty(String.format(USER_TEMPLATE, ds)), this.getProperty(String.format(PASSWORD_TEMPLATE, ds)));
        dp.setInitialSize(this.getPropertyToInt(String.format(INITSIZE_TEMPLATE, ds)));
        dp.setMaxActive(this.getPropertyToInt(String.format(MAXSIZE_TEMPLATE, ds)));
        dp.addFilter((Filter)new StatFilter());
        WallFilter wall = new WallFilter();
        wall.setDbType(ds);
        dp.addFilter((Filter)wall);
        if (this.geRuned) {
            dp.start();
            BaseModelGeneratorExt baseGe = new BaseModelGeneratorExt(this.getBaseModelPackage(), this.getBaseModelOutDir());
            baseGe.setGenerateTableNameInModel(this.getGeTableNameInModel());
            baseGe.setGenerateTableColumnNameInModel(this.getGeTableColumnName());
            ModelGenerator modelGe = new ModelGenerator(this.getModelPackage(), this.getBaseModelPackage(), this.getModelOutDir());
            modelGe.setGenerateDaoInModel(this.getGeDaoInModel());
            Generator ge = new Generator(dp.getDataSource(), (BaseModelGenerator)baseGe, modelGe);
            MappingKitGeneratorExt mappingKitGe = new MappingKitGeneratorExt(this.getModelPackage(), this.getModelOutDir());
            if (!DEFAULT_MAPPINGKIT_CLASS_NAME.equals(this.getMappingKitClassName())) {
                mappingKitGe.setMappingKitClassName(this.getMappingKitClassName());
            }
            mappingKitGe.setGenerateMappingArpKit(this.getGeMappingArpKit());
            mappingKitGe.setGenerateTableMapping(this.getGeTableMapping());
            ge.setMappingKitGenerator((MappingKitGenerator)mappingKitGe);
            ge.setGenerateDataDictionary(this.getGeDictionary());
            ge.generate();
        }
        return dp;
    }

    private ActiveRecordPlugin getActiveRecordPlugin(String ds, DruidPlugin dp) {
        this.loadPropertyFile();
        ActiveRecordPlugin arp = new ActiveRecordPlugin(ds, (IDataSourceProvider)dp);
        arp.setShowSql(this.getPropertyToBoolean("db.showsql").booleanValue());
        if (!this.geRuned) {
            try {
                Class<?> clazz = Class.forName(this.getModelPackage() + "." + this.getMappingKitClassName());
                Method mapping = clazz.getMethod("mapping", ActiveRecordPlugin.class);
                mapping.invoke(clazz, arp);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(String.valueOf(e) + ",may be your table is not contain `PrimaryKey`.");
            }
        }
        return arp;
    }

    private boolean getGeDictionary() {
        this.loadPropertyFile();
        return this.getPropertyToBoolean("ge.dict", false);
    }

    private String getBaseModelOutDir() {
        this.loadPropertyFile();
        return this.getProperty("ge.base.model.outdir");
    }

    private String getBaseModelPackage() {
        this.loadPropertyFile();
        return this.getProperty("ge.base.model.package");
    }

    private boolean getGeDaoInModel() {
        this.loadPropertyFile();
        if (this.geDaoInModel == null) {
            this.geDaoInModel = this.getPropertyToBoolean("ge.model.dao", Boolean.TRUE);
        }
        return this.geDaoInModel;
    }

    private boolean getGeTableNameInModel() {
        this.loadPropertyFile();
        if (this.geTableNameInModel == null) {
            this.geTableNameInModel = this.getPropertyToBoolean("ge.model.table", Boolean.TRUE);
        }
        return this.geTableNameInModel;
    }

    private String getModelOutDir() {
        this.loadPropertyFile();
        return this.getProperty("ge.model.outdir");
    }

    private String getModelPackage() {
        this.loadPropertyFile();
        return this.getProperty("ge.model.package");
    }

    private String getMappingKitClassName() {
        this.loadPropertyFile();
        if (this.mappingKitClassName == null) {
            this.mappingKitClassName = this.getProperty("ge.mappingkit.classname", DEFAULT_MAPPINGKIT_CLASS_NAME);
        }
        return this.mappingKitClassName;
    }

    private boolean getGeMappingArpKit() {
        this.loadPropertyFile();
        return this.getPropertyToBoolean("ge.mappingarpkit", true);
    }

    private boolean getGeTableMapping() {
        this.loadPropertyFile();
        return this.getPropertyToBoolean("ge.tablemapping", true);
    }

    private boolean getGeTableColumnName() {
        this.loadPropertyFile();
        return this.getPropertyToBoolean("ge.model.tablecolumn", true);
    }

    public String getProperty(String key) {
        String p = super.getProperty(key);
        if (StrKit.isBlank((String)p)) {
            new IllegalArgumentException("`" + key + "` Cannot be empty, set `" + key + "` in cfg.txt file");
        }
        return p;
    }
}

