/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.render.csv;

import com.jfinal.ext.render.csv.UserSettings;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CsvUtil {
    private static UserSettings userSettings = new UserSettings();

    private CsvUtil() {
    }

    public static String createCSV(List headers, List data, List columns) {
        StringBuffer strOut = new StringBuffer("");
        if (null != headers && !headers.isEmpty()) {
            CsvUtil.listToCSV(strOut, headers);
        }
        if (null == data || data.isEmpty()) {
            return strOut.toString();
        }
        Iterator itr = data.iterator();
        while (itr.hasNext()) {
            Object objs;
            Object obj = itr.next();
            Class<?> cls = obj.getClass();
            if (cls != null && cls.isArray()) {
                if (obj != null && (objs = (Object[])obj) != null) {
                    for (int i = 0; i < ((Object[])objs).length; i = (int)((short)(i + 1))) {
                        CsvUtil.createCol(strOut, objs[i]);
                        strOut.append(",");
                    }
                    strOut = strOut.deleteCharAt(strOut.length() - 1);
                    strOut.append("\n");
                }
            } else if (obj instanceof List) {
                List objlist = (List)obj;
                if (null == columns || columns.isEmpty()) {
                    CsvUtil.listToCSV(strOut, objlist);
                } else {
                    for (int i = 0; i < columns.size(); ++i) {
                        CsvUtil.createCol(strOut, objlist.get((Integer)columns.get(i)));
                        strOut.append(",");
                    }
                    strOut = strOut.deleteCharAt(strOut.length() - 1);
                    strOut.append("\n");
                }
            } else if (obj instanceof Map) {
                Map objmap = (Map)obj;
                if (null == columns || columns.isEmpty()) {
                    Set keyset = objmap.keySet();
                    for (Object key : keyset) {
                        CsvUtil.createCol(strOut, objmap.get(key));
                        strOut.append(",");
                    }
                    strOut = strOut.deleteCharAt(strOut.length() - 1);
                    strOut.append("\n");
                } else {
                    for (int i = 0; i < columns.size(); ++i) {
                        CsvUtil.createCol(strOut, objmap.get(columns.get(i)));
                        strOut.append(",");
                    }
                    strOut = strOut.deleteCharAt(strOut.length() - 1);
                    strOut.append("\n");
                }
            } else if (obj instanceof Model) {
                Model objmodel = (Model)obj;
                if (null == columns || columns.isEmpty()) {
                    Set entries = objmodel._getAttrsEntrySet();
                    for (Map.Entry entry : entries) {
                        CsvUtil.createCol(strOut, entry.getValue());
                        strOut.append(",");
                    }
                    strOut = strOut.deleteCharAt(strOut.length() - 1);
                    strOut.append("\n");
                } else {
                    for (int i = 0; i < columns.size(); ++i) {
                        CsvUtil.createCol(strOut, objmodel.get(columns.get(i) + ""));
                        strOut.append(",");
                    }
                    strOut = strOut.deleteCharAt(strOut.length() - 1);
                    strOut.append("\n");
                }
            } else if (obj instanceof Record) {
                Record objrecord = (Record)obj;
                Map map = objrecord.getColumns();
                if (null == columns || columns.isEmpty()) {
                    Set keys = map.keySet();
                    for (String key : keys) {
                        CsvUtil.createCol(strOut, objrecord.get(key));
                        strOut.append(",");
                    }
                    strOut = strOut.deleteCharAt(strOut.length() - 1);
                    strOut.append("\n");
                } else {
                    for (int i = 0; i < columns.size(); ++i) {
                        CsvUtil.createCol(strOut, objrecord.get(columns.get(i) + ""));
                        strOut.append(",");
                    }
                    strOut = strOut.deleteCharAt(strOut.length() - 1);
                    strOut.append("\n");
                }
            } else {
                while (itr.hasNext()) {
                    objs = itr.next();
                    if (objs == null) continue;
                    CsvUtil.createCol(strOut, objs);
                    strOut.append("\n");
                }
            }
            obj = null;
        }
        return strOut.toString();
    }

    public static void listToCSV(StringBuffer strOut, List<?> list) {
        if (null != list && !list.isEmpty()) {
            for (int i = 0; i < list.size(); i = (int)((short)(i + 1))) {
                CsvUtil.createCol(strOut, list.get(i));
                strOut.append(",");
            }
            strOut = strOut.deleteCharAt(strOut.length() - 1);
            strOut.append("\n");
        }
    }

    public static void createCol(StringBuffer strOut, Object obj) {
        if (obj != null) {
            strOut.append("\"");
            String content = null;
            content = obj instanceof Boolean ? ((Boolean)obj).toString() : (obj instanceof Calendar ? ((Calendar)obj).toString() : (obj instanceof Timestamp ? new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date(((Timestamp)obj).getTime())) : (obj instanceof Date ? new SimpleDateFormat("yyyy-MM-dd HH:mm").format((Date)obj) : CsvUtil.write(String.valueOf(obj)))));
            strOut.append(content);
            strOut.append("\"");
        } else {
            strOut.append("\" \" ");
        }
    }

    public static String write(String content) {
        boolean textQualify = CsvUtil.userSettings.forceQualifier;
        if (content.length() > 0) {
            content = content.trim();
        }
        if (!textQualify && CsvUtil.userSettings.useTextQualifier && (content.indexOf(CsvUtil.userSettings.textQualifier) > -1 || content.indexOf(CsvUtil.userSettings.delimiter) > -1 || content.indexOf(10) > -1 || content.indexOf(13) > -1 || content.indexOf(CsvUtil.userSettings.recordDelimiter) > -1 || content.length() > 0 && content.charAt(0) == CsvUtil.userSettings.comment || content.length() == 0)) {
            textQualify = true;
        }
        if (CsvUtil.userSettings.useTextQualifier && !textQualify && content.length() > 0) {
            char lastLetter;
            char firstLetter = content.charAt(0);
            if (firstLetter == ' ' || firstLetter == '\t') {
                textQualify = true;
            }
            if (!(textQualify || content.length() <= 1 || (lastLetter = content.charAt(content.length() - 1)) != ' ' && lastLetter != '\t')) {
                textQualify = true;
            }
        }
        if (textQualify) {
            if (CsvUtil.userSettings.escapeMode == 2) {
                content = CsvUtil.replace(content, "\\", "\\\\");
                content = CsvUtil.replace(content, "" + CsvUtil.userSettings.textQualifier, "\\" + CsvUtil.userSettings.textQualifier);
            } else {
                content = CsvUtil.replace(content, "" + CsvUtil.userSettings.textQualifier, "" + CsvUtil.userSettings.textQualifier + CsvUtil.userSettings.textQualifier);
            }
        } else if (CsvUtil.userSettings.escapeMode == 2) {
            content = CsvUtil.replace(content, "\\", "\\\\");
            content = CsvUtil.replace(content, "" + CsvUtil.userSettings.delimiter, "\\" + CsvUtil.userSettings.delimiter);
            content = CsvUtil.replace(content, "\r", "\\\r");
            content = CsvUtil.replace(content, "\n", "\\\n");
        }
        return content;
    }

    public static String replace(String original, String pattern, String replace) {
        int len = pattern.length();
        int found = original.indexOf(pattern);
        if (found > -1) {
            StringBuffer sb = new StringBuffer();
            int start = 0;
            while (found != -1) {
                sb.append(original.substring(start, found));
                sb.append(replace);
                start = found + len;
                found = original.indexOf(pattern, start);
            }
            sb.append(original.substring(start));
            return sb.toString();
        }
        return original;
    }
}

