/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.monogodb;

import com.jfinal.log.Log;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class MongoKit {
    protected static Log logger = Log.getLog(MongoKit.class);
    private static MongoClient client;
    private static DB defaultDb;

    public static void init(MongoClient client, String database) {
        MongoKit.client = client;
        defaultDb = client.getDB(database);
    }

    public static void updateFirst(String collectionName, Map<String, Object> q, Map<String, Object> o) {
        MongoKit.getCollection(collectionName).findAndModify((DBObject)MongoKit.toDBObject(q), (DBObject)MongoKit.toDBObject(o));
    }

    public static int removeAll(String collectionName) {
        return MongoKit.getCollection(collectionName).remove((DBObject)new BasicDBObject()).getN();
    }

    public static int remove(String collectionName, Map<String, Object> filter) {
        return MongoKit.getCollection(collectionName).remove((DBObject)MongoKit.toDBObject(filter)).getN();
    }

    public static int save(String collectionName, List<Record> records) {
        ArrayList<BasicDBObject> objs = new ArrayList<BasicDBObject>();
        for (Record record : records) {
            objs.add(MongoKit.toDbObject(record));
        }
        return MongoKit.getCollection(collectionName).insert(objs).getN();
    }

    public static int save(String collectionName, Record record) {
        return MongoKit.getCollection(collectionName).save((DBObject)MongoKit.toDbObject(record)).getN();
    }

    public static Record findFirst(String collectionName) {
        return MongoKit.toRecord(MongoKit.getCollection(collectionName).findOne());
    }

    public static Page<Record> paginate(String collection, int pageNumber, int pageSize) {
        return MongoKit.paginate(collection, pageNumber, pageSize, null, null, null);
    }

    public static Page<Record> paginate(String collection, int pageNumber, int pageSize, Map<String, Object> filter) {
        return MongoKit.paginate(collection, pageNumber, pageSize, filter, null, null);
    }

    public static Page<Record> paginate(String collection, int pageNumber, int pageSize, Map<String, Object> filter, Map<String, Object> like) {
        return MongoKit.paginate(collection, pageNumber, pageSize, filter, like, null);
    }

    public static Page<Record> paginate(String collection, int pageNumber, int pageSize, Map<String, Object> filter, Map<String, Object> like, Map<String, Object> sort) {
        DBCollection logs = MongoKit.getCollection(collection);
        BasicDBObject conditons = new BasicDBObject();
        MongoKit.buildFilter(filter, conditons);
        MongoKit.buildLike(like, conditons);
        DBCursor dbCursor = logs.find((DBObject)conditons);
        MongoKit.page(pageNumber, pageSize, dbCursor);
        MongoKit.sort(sort, dbCursor);
        ArrayList<Record> records = new ArrayList<Record>();
        while (dbCursor.hasNext()) {
            records.add(MongoKit.toRecord(dbCursor.next()));
        }
        int totalRow = dbCursor.count();
        if (totalRow <= 0) {
            return new Page(new ArrayList(0), pageNumber, pageSize, 0, 0);
        }
        int totalPage = totalRow / pageSize;
        if (totalRow % pageSize != 0) {
            ++totalPage;
        }
        Page page = new Page(records, pageNumber, pageSize, totalPage, totalRow);
        return page;
    }

    private static void page(int pageNumber, int pageSize, DBCursor dbCursor) {
        dbCursor = dbCursor.skip((pageNumber - 1) * pageSize).limit(pageSize);
    }

    private static void sort(Map<String, Object> sort, DBCursor dbCursor) {
        if (sort != null) {
            BasicDBObject dbo = new BasicDBObject();
            Set<Map.Entry<String, Object>> entrySet = sort.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                String key = entry.getKey();
                Object val = entry.getValue();
                dbo.put(key, (Object)("asc".equalsIgnoreCase(val + "") ? 1 : -1));
            }
            dbCursor = dbCursor.sort((DBObject)dbo);
        }
    }

    private static void buildLike(Map<String, Object> like, BasicDBObject conditons) {
        if (like != null) {
            Set<Map.Entry<String, Object>> entrySet = like.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                String key = entry.getKey();
                Object val = entry.getValue();
                conditons.put(key, (Object)MongoKit.getLikeStr(val));
            }
        }
    }

    private static void buildFilter(Map<String, Object> filter, BasicDBObject conditons) {
        if (filter != null) {
            Set<Map.Entry<String, Object>> entrySet = filter.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                String key = entry.getKey();
                Object val = entry.getValue();
                conditons.put(key, val);
            }
        }
    }

    public static Record toRecord(DBObject dbObject) {
        Record record = new Record();
        record.setColumns(dbObject.toMap());
        return record;
    }

    public static BasicDBObject getLikeStr(Object findStr) {
        Pattern pattern = Pattern.compile("^.*" + findStr + ".*$", 2);
        return new BasicDBObject("$regex", (Object)pattern);
    }

    public static DB getDB() {
        return defaultDb;
    }

    public static DB getDB(String dbName) {
        return client.getDB(dbName);
    }

    public static DBCollection getCollection(String name) {
        return defaultDb.getCollection(name);
    }

    public static DBCollection getDBCollection(String dbName, String collectionName) {
        return MongoKit.getDB(dbName).getCollection(collectionName);
    }

    public static MongoClient getClient() {
        return client;
    }

    public static void setMongoClient(MongoClient client) {
        MongoKit.client = client;
    }

    private static BasicDBObject toDBObject(Map<String, Object> map) {
        BasicDBObject dbObject = new BasicDBObject();
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Object val = entry.getValue();
            dbObject.append(key, val);
        }
        return dbObject;
    }

    private static BasicDBObject toDbObject(Record record) {
        BasicDBObject object = new BasicDBObject();
        for (Map.Entry e : record.getColumns().entrySet()) {
            object.append((String)e.getKey(), e.getValue());
        }
        return object;
    }
}

