/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.jms;

import com.jfinal.ext.plugin.jms.JmsConfig;
import com.jfinal.ext.plugin.jms.ReceiveResolver;
import com.jfinal.log.Log;
import java.util.HashMap;
import java.util.Map;

public class ReceiveResolverFactory {
    public static final String RESOLVER_SUFFIX = ".resolver";
    protected final Log logger = Log.getLog(this.getClass());
    private Map<Integer, ReceiveResolver> receiveResolverMap = new HashMap<Integer, ReceiveResolver>();
    private Map<String, Integer> messageTypeMap;
    private String resoruceLocation;
    private String typeFilter;

    public ReceiveResolverFactory(String resoruceLocation, String typeFilter) {
        this.resoruceLocation = resoruceLocation;
        this.typeFilter = typeFilter;
    }

    public ReceiveResolver createReceiveResolver(Integer messageType) {
        this.logger.debug(" receive messageType " + messageType);
        if (this.messageTypeMap == null) {
            this.init();
        }
        return this.receiveResolverMap.get(messageType);
    }

    public Integer getMessageType(String key) {
        if (this.messageTypeMap == null) {
            this.init();
        }
        return this.messageTypeMap.get(key);
    }

    private synchronized void init() {
        this.messageTypeMap = new HashMap<String, Integer>();
        try {
            this.loadReceiveResolver();
        }
        catch (Exception e) {
            this.logger.error("load ReceiveResolver error, it is defined in file" + this.resoruceLocation, (Throwable)e);
        }
        this.logger.debug("resolvers in  " + this.typeFilter + " :" + this.receiveResolverMap);
    }

    private void loadReceiveResolver() {
        for (String key : JmsConfig.keys()) {
            if (!key.startsWith(this.typeFilter) || key.endsWith(RESOLVER_SUFFIX)) continue;
            Integer messageType = new Integer(JmsConfig.getStr(key));
            String messageResolver = JmsConfig.getStr(key + RESOLVER_SUFFIX);
            this.messageTypeMap.put(key, messageType);
            try {
                this.receiveResolverMap.put(messageType, (ReceiveResolver)Class.forName(messageResolver).newInstance());
            }
            catch (Exception e) {
                this.logger.error("cant create " + messageResolver, (Throwable)e);
            }
        }
    }
}

