/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.plugin.config;

import com.google.common.collect.Lists;
import com.jfinal.ext.plugin.config.ConfigKit;
import com.jfinal.log.Log;
import com.jfinal.plugin.IPlugin;
import java.util.List;

public class ConfigPlugin
implements IPlugin {
    static String suffix = "txt";
    protected final Log LOG = Log.getLog(this.getClass());
    private final List<String> includeResources = Lists.newArrayList();
    private final List<String> excludeResources = Lists.newArrayList();
    private boolean reload = true;

    public ConfigPlugin(String ... includeResources) {
        if (includeResources != null) {
            for (String includeResource : includeResources) {
                this.includeResources.add(includeResource);
            }
        }
    }

    public ConfigPlugin excludeResource(String ... resource) {
        if (this.includeResources != null) {
            for (String excludeResource : this.excludeResources) {
                this.excludeResources.add(excludeResource);
            }
        }
        return this;
    }

    public ConfigPlugin addResource(String resource) {
        this.includeResources.add(resource);
        return this;
    }

    public ConfigPlugin reload(boolean reload) {
        this.reload = reload;
        return this;
    }

    public static void setSuffix(String suffix) {
        ConfigPlugin.suffix = suffix;
    }

    public boolean start() {
        ConfigKit.init(this.includeResources, this.excludeResources, this.reload);
        return true;
    }

    public boolean stop() {
        return true;
    }
}

