/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.kit.excel;

import com.google.common.collect.Lists;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.ext.kit.excel.ExcelException;
import com.jfinal.ext.kit.excel.Rule;
import com.jfinal.ext.kit.excel.convert.CellConvert;
import com.jfinal.ext.kit.excel.filter.RowFilter;
import com.jfinal.ext.kit.excel.validate.CellValidate;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.Model;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class PoiImporter {
    public static List<List<List<String>>> readExcel(File file, Rule rule) {
        Workbook wb;
        int start = rule.getStart();
        int end = rule.getEnd();
        ArrayList result = Lists.newArrayList();
        try {
            wb = WorkbookFactory.create((File)file);
        }
        catch (Exception e) {
            throw new ExcelException(e);
        }
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            Sheet sheet = wb.getSheetAt(i);
            ArrayList sheetList = Lists.newArrayList();
            int rows = sheet.getLastRowNum();
            if (start <= sheet.getFirstRowNum()) {
                start = sheet.getFirstRowNum();
            }
            if (end >= rows) {
                end = rows;
            } else if (end <= 0) {
                end = rows + end;
            }
            for (int rowIndex = start; rowIndex <= end; ++rowIndex) {
                Row row = sheet.getRow(rowIndex);
                ArrayList columns = Lists.newArrayList();
                short cellNum = row.getLastCellNum();
                System.out.println(row.getLastCellNum());
                System.out.println(row.getPhysicalNumberOfCells());
                for (int cellIndex = row.getFirstCellNum(); cellIndex < cellNum; ++cellIndex) {
                    Cell cell = row.getCell(cellIndex);
                    int cellType = cell.getCellType();
                    String column = "";
                    switch (cellType) {
                        case 0: {
                            column = String.valueOf(cell.getDateCellValue());
                            break;
                        }
                        case 1: {
                            column = cell.getStringCellValue();
                            break;
                        }
                        case 4: {
                            column = cell.getBooleanCellValue() + "";
                            break;
                        }
                        case 2: {
                            column = cell.getCellFormula();
                            break;
                        }
                        case 3: 
                        case 5: {
                            column = " ";
                            break;
                        }
                    }
                    columns.add(column.trim());
                }
                ArrayList rowFilterFlagList = Lists.newArrayList();
                ArrayList rowFilterList = Lists.newArrayList();
                for (int k = 0; k < rowFilterList.size(); ++k) {
                    RowFilter rowFilter = (RowFilter)rowFilterList.get(k);
                    rowFilterFlagList.add(rowFilter.doFilter(rowIndex, columns));
                }
                if (rowFilterFlagList.contains(false)) continue;
                sheetList.add(columns);
            }
            result.add(sheetList);
        }
        return result;
    }

    public static List<List<String>> readSheet(File file, Rule Rule2) {
        return PoiImporter.readExcel(file, Rule2).get(0);
    }

    public static List<Model<?>> processSheet(File file, Rule Rule2, Class clazz) {
        List<List<String>> srcList = PoiImporter.readSheet(file, Rule2);
        ArrayList results = Lists.newArrayList();
        for (int i = 0; i < srcList.size(); ++i) {
            List<String> list = srcList.get(i);
            Model<?> model = PoiImporter.fillModel(clazz, list, Rule2);
            results.add(model);
        }
        return results;
    }

    public static Model<?> fillModel(Class<?> clazz, List<String> list, Rule rule) {
        Model model = (Model)Reflect.on(clazz).create().get();
        String[] values = list.toArray(new String[0]);
        String message = "";
        for (int i = 0; i < values.length; ++i) {
            CellValidate cellValidate;
            String value = values[i];
            Rule.Cell cell = PoiImporter.matchCell(rule, i);
            String name = cell.getAttribute();
            String validateClassName = cell.getValidate();
            boolean valid = true;
            if (StrKit.notBlank((String)validateClassName) && !(valid = (cellValidate = (CellValidate)Reflect.on(validateClassName).create().get()).validate(value))) {
                message = message + "value(" + value + ") is invalid in column " + cell.getIndex() + "</br>";
            }
            if (!valid) continue;
            String convertedValue = value;
            String convertClassName = cell.getConvert();
            if (StrKit.notBlank((String)convertClassName)) {
                CellConvert cellConvert = (CellConvert)Reflect.on(convertClassName).get();
                convertedValue = cellConvert.convert(value, model);
            }
            model.set(name, (Object)convertedValue);
        }
        if (StrKit.notBlank((String)message)) {
            throw new ExcelException(message);
        }
        return model;
    }

    public static Rule.Cell matchCell(Rule rule, int index) {
        List<Rule.Cell> cells = rule.getCells();
        for (int i = 0; i < cells.size(); ++i) {
            Rule.Cell cell = cells.get(i);
            if (index + 1 != cell.getIndex()) continue;
            return cell;
        }
        return null;
    }
}

