/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.kit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jfinal.ext.kit.Reflect;
import com.jfinal.log.Log;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelKit {
    protected static final Log logger = Log.getLog(ModelKit.class);

    public static Record toRecord(Model<?> model) {
        return model.toRecord();
    }

    public static Model set(Model model, Object ... attrsAndValues) {
        int length = attrsAndValues.length;
        Preconditions.checkArgument((length % 2 == 0 ? 1 : 0) != 0, (String)"attrsAndValues length must be even number", (Object[])new Object[]{length});
        for (int i = 0; i < length; i += 2) {
            Object attr = attrsAndValues[i];
            Preconditions.checkArgument((boolean)(attr instanceof String), (Object)"the odd number of attrsAndValues  must be String");
            model.set((String)attr, attrsAndValues[i + 1]);
        }
        return model;
    }

    public static Map<String, Object> toMap(Model model) {
        HashMap map = Maps.newHashMap();
        Set attrs = model._getAttrsEntrySet();
        for (Map.Entry entry : attrs) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static Model<?> fromBean(Class<? extends Model<?>> clazz, Object bean) {
        Model<?> model = null;
        try {
            model = clazz.newInstance();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return model;
        }
        return model;
    }

    public static int[] batchSave(List<? extends Model> data) {
        return ModelKit.batchSave(data, data.size());
    }

    public static int[] batchSave(List<? extends Model> data, int batchSize) {
        Model model = data.get(0);
        Map attrs = (Map)Reflect.on(model).field("attrs").get();
        Class<?> modelClass = model.getClass();
        Table tableInfo = TableMapping.me().getTable(modelClass);
        StringBuilder sql = new StringBuilder();
        ArrayList paras = Lists.newArrayList();
        DbKit.getConfig().getDialect().forModelSave(tableInfo, attrs, sql, (List)paras);
        Object[][] batchPara = new Object[data.size()][attrs.size()];
        for (int i = 0; i < data.size(); ++i) {
            int j = 0;
            for (String key : attrs.keySet()) {
                batchPara[i][j++] = data.get(i).get(key);
            }
        }
        return Db.batch((String)sql.toString(), (Object[][])batchPara, (int)batchSize);
    }

    public static void copyColumns(Model src, Model desc, String ... columns) {
        for (String column : columns) {
            String[] res = column.split(",");
            if (res.length == 1) {
                desc.set(column, src.get(column));
                continue;
            }
            desc.set(res[1], src.get(res[0]));
        }
    }

    public static void clone(Model src, Model desc) {
        Set attrs = src._getAttrsEntrySet();
        for (Map.Entry attr : attrs) {
            String key = (String)attr.getKey();
            Object value = attr.getValue();
            desc.set(key, value);
        }
    }

    public static int hashCode(Model<?> model) {
        int prime = 31;
        int result = 1;
        Table tableinfo = TableMapping.me().getTable(model.getClass());
        Set attrsEntrySet = model._getAttrsEntrySet();
        for (Map.Entry entry : attrsEntrySet) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Class clazz = tableinfo.getColumnType(key);
            if (clazz == Integer.class) {
                result = 31 * result + (Integer)value;
                continue;
            }
            if (clazz == Short.class) {
                result = 31 * result + (Short)value;
                continue;
            }
            if (clazz == Long.class) {
                result = 31 * result + (int)((Long)value ^ (Long)value >>> 32);
                continue;
            }
            if (clazz == Float.class) {
                result = 31 * result + Float.floatToIntBits(((Float)value).floatValue());
                continue;
            }
            if (clazz == Double.class) {
                long temp = Double.doubleToLongBits((Double)value);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                continue;
            }
            if (clazz == Boolean.class) {
                result = 31 * result + ((Boolean)value != false ? 1231 : 1237);
                continue;
            }
            if (clazz == Model.class) {
                result = ModelKit.hashCode((Model)value);
                continue;
            }
            result = 31 * result + (value == null ? 0 : value.hashCode());
        }
        return result;
    }

    public static boolean equals(Model<?> model, Object obj) {
        if (model == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (model.getClass() != obj.getClass()) {
            return false;
        }
        Model other = (Model)obj;
        Table tableinfo = TableMapping.me().getTable(model.getClass());
        Set attrsEntrySet = model._getAttrsEntrySet();
        for (Map.Entry entry : attrsEntrySet) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Class clazz = tableinfo.getColumnType(key);
            if (clazz == Float.class || clazz == Double.class || clazz == Model.class || !(value == null ? other.get(key) != null : !value.equals(other.get(key)))) continue;
            return false;
        }
        return true;
    }
}

