/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.ext.directive;

import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.TemplateException;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.io.IOException;

public class EscapeDirective
extends Directive {
    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        try {
            Object value = this.exprList.eval(scope);
            if (value instanceof String) {
                this.escape((String)value, writer);
            } else if (value instanceof Number) {
                Class<?> c = value.getClass();
                if (c == Integer.class) {
                    writer.write((Integer)value);
                } else if (c == Long.class) {
                    writer.write((Long)value);
                } else if (c == Double.class) {
                    writer.write((Double)value);
                } else if (c == Float.class) {
                    writer.write(((Float)value).floatValue());
                } else {
                    writer.write(value.toString());
                }
            } else if (value != null) {
                this.escape(value.toString(), writer);
            }
        }
        catch (TemplateException | ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }

    private void escape(String str, Writer w) throws IOException {
        int len = str.length();
        block7: for (int i = 0; i < len; ++i) {
            char cur = str.charAt(i);
            switch (cur) {
                case '<': {
                    w.write("&lt;");
                    continue block7;
                }
                case '>': {
                    w.write("&gt;");
                    continue block7;
                }
                case '\"': {
                    w.write("&quot;");
                    continue block7;
                }
                case '\'': {
                    w.write("&#39;");
                    continue block7;
                }
                case '&': {
                    w.write("&amp;");
                    continue block7;
                }
                default: {
                    w.write(str, i, 1);
                }
            }
        }
    }
}

