/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.generator;

import com.jfinal.kit.Kv;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import com.jfinal.template.Engine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

public class MappingKitGenerator {
    protected Engine engine;
    protected String template = "/com/jfinal/plugin/activerecord/generator/mapping_kit_template.jf";
    protected String mappingKitPackageName;
    protected String mappingKitOutputDir;
    protected String mappingKitClassName = "_MappingKit";

    public MappingKitGenerator(String mappingKitPackageName, String mappingKitOutputDir) {
        this.mappingKitPackageName = mappingKitPackageName;
        this.mappingKitOutputDir = mappingKitOutputDir;
        this.initEngine();
    }

    protected void initEngine() {
        this.engine = new Engine();
        this.engine.setToClassPathSourceFactory();
        this.engine.addSharedMethod(new StrKit());
        this.engine.setStaticFieldExpression(true);
        this.engine.setStaticMethodExpression(true);
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setMappingKitOutputDir(String mappingKitOutputDir) {
        if (StrKit.notBlank(mappingKitOutputDir)) {
            this.mappingKitOutputDir = mappingKitOutputDir;
        }
    }

    public String getMappingKitOutputDir() {
        return this.mappingKitOutputDir;
    }

    public void setMappingKitPackageName(String mappingKitPackageName) {
        if (StrKit.notBlank(mappingKitPackageName)) {
            this.mappingKitPackageName = mappingKitPackageName;
        }
    }

    public String getMappingKitPackageName() {
        return this.mappingKitPackageName;
    }

    public void setMappingKitClassName(String mappingKitClassName) {
        if (StrKit.notBlank(mappingKitClassName)) {
            this.mappingKitClassName = StrKit.firstCharToUpperCase(mappingKitClassName);
        }
    }

    public String getMappingKitClassName() {
        return this.mappingKitClassName;
    }

    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate MappingKit file ...");
        System.out.println("MappingKit Output Dir: " + this.mappingKitOutputDir);
        Kv data = Kv.of("mappingKitPackageName", this.mappingKitPackageName);
        data.set("mappingKitClassName", this.mappingKitClassName);
        data.set("tableMetas", tableMetas);
        String ret = this.engine.getTemplate(this.template).renderToString(data);
        this.writeToFile(ret);
    }

    protected void writeToFile(String ret) {
        File dir = new File(this.mappingKitOutputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String target = this.mappingKitOutputDir + File.separator + this.mappingKitClassName + ".java";
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(target), "UTF-8");){
            osw.write(ret);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Engine getEngine() {
        return this.engine;
    }
}

