/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.kit.Func;
import com.jfinal.kit.TypeKit;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.IRow;
import com.jfinal.plugin.activerecord.Model;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Record
implements IRow<Record>,
Serializable {
    private static final long serialVersionUID = 905784513600884082L;
    private Map<String, Object> columns;
    Set<String> modifyFlag;

    Set<String> _getModifyFlag() {
        if (this.modifyFlag == null) {
            Config config = DbKit.getConfig();
            this.modifyFlag = config == null ? DbKit.brokenConfig.containerFactory.getModifyFlagSet() : config.containerFactory.getModifyFlagSet();
        }
        return this.modifyFlag;
    }

    void clearModifyFlag() {
        if (this.modifyFlag != null) {
            this.modifyFlag.clear();
        }
    }

    public Record setContainerFactoryByConfigName(String configName) {
        Config config = DbKit.getConfig(configName);
        if (config == null) {
            throw new IllegalArgumentException("Config not found: " + configName);
        }
        this.processColumnsMap(config);
        return this;
    }

    void setColumnsMap(Map<String, Object> columns) {
        this.columns = columns;
    }

    private void processColumnsMap(Config config) {
        if (this.columns == null || this.columns.size() == 0) {
            this.columns = config.containerFactory.getColumnsMap();
        } else {
            Map<String, Object> columnsOld = this.columns;
            this.columns = config.containerFactory.getColumnsMap();
            this.columns.putAll(columnsOld);
        }
    }

    public Map<String, Object> getColumns() {
        if (this.columns == null) {
            this.columns = DbKit.config == null ? DbKit.brokenConfig.containerFactory.getColumnsMap() : DbKit.config.containerFactory.getColumnsMap();
        }
        return this.columns;
    }

    public Record setColumns(Map<String, Object> columns) {
        for (Map.Entry<String, Object> e : columns.entrySet()) {
            this.set(e.getKey(), e.getValue());
        }
        return this;
    }

    public Record setColumns(Record record) {
        return this.setColumns(record.getColumns());
    }

    public Record setColumns(Model<?> model) {
        return this.setColumns(model._getAttrs());
    }

    public Record remove(String column) {
        this.getColumns().remove(column);
        this._getModifyFlag().remove(column);
        return this;
    }

    public Record remove(String ... columns) {
        if (columns != null) {
            for (String c : columns) {
                this.getColumns().remove(c);
                this._getModifyFlag().remove(c);
            }
        }
        return this;
    }

    public Record removeNullValueColumns() {
        Iterator<Map.Entry<String, Object>> it = this.getColumns().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            if (e.getValue() != null) continue;
            it.remove();
            this._getModifyFlag().remove(e.getKey());
        }
        return this;
    }

    public Record keep(String ... columns) {
        if (columns != null && columns.length > 0) {
            Config config = DbKit.getConfig();
            if (config == null) {
                config = DbKit.brokenConfig;
            }
            Map newColumns = config.containerFactory.getColumnsMap();
            Set newModifyFlag = config.containerFactory.getModifyFlagSet();
            for (String c : columns) {
                if (this.getColumns().containsKey(c)) {
                    newColumns.put(c, this.columns.get(c));
                }
                if (!this._getModifyFlag().contains(c)) continue;
                newModifyFlag.add(c);
            }
            this.columns = newColumns;
            this.modifyFlag = newModifyFlag;
        } else {
            this.getColumns().clear();
            this.clearModifyFlag();
        }
        return this;
    }

    public Record keep(String column) {
        if (this.getColumns().containsKey(column)) {
            Object keepIt = this.getColumns().get(column);
            this.getColumns().clear();
            this.getColumns().put(column, keepIt);
            boolean keepFlag = this._getModifyFlag().contains(column);
            this.clearModifyFlag();
            if (keepFlag) {
                this._getModifyFlag().add(column);
            }
        } else {
            this.getColumns().clear();
            this.clearModifyFlag();
        }
        return this;
    }

    public Record clear() {
        this.getColumns().clear();
        this.clearModifyFlag();
        return this;
    }

    @Override
    public Record set(String column, Object value) {
        this.getColumns().put(column, value);
        this._getModifyFlag().add(column);
        return this;
    }

    @Override
    public <T> T get(String column) {
        return (T)this.getColumns().get(column);
    }

    @Override
    public <T> T get(String column, T defaultValue) {
        Object result = this.getColumns().get(column);
        return (T)(result != null ? result : defaultValue);
    }

    @Override
    public <T> T get(String column, T defaultValue, Func.F11<Object, T> converter) {
        Object result = this.getColumns().get(column);
        return result != null ? converter.call(result) : defaultValue;
    }

    public Object getObject(String column) {
        return this.getColumns().get(column);
    }

    public Object getObject(String column, Object defaultValue) {
        Object result = this.getColumns().get(column);
        return result != null ? result : defaultValue;
    }

    @Override
    public String getStr(String column) {
        Object s = this.getColumns().get(column);
        return s != null ? s.toString() : null;
    }

    @Override
    public Integer getInt(String column) {
        return TypeKit.toInt(this.getColumns().get(column));
    }

    @Override
    public Long getLong(String column) {
        return TypeKit.toLong(this.getColumns().get(column));
    }

    @Override
    public BigInteger getBigInteger(String column) {
        Object n = this.getColumns().get(column);
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        if (n instanceof BigDecimal) {
            return ((BigDecimal)n).toBigInteger();
        }
        if (n instanceof Number) {
            return BigInteger.valueOf(((Number)n).longValue());
        }
        if (n instanceof String) {
            return new BigInteger((String)n);
        }
        return (BigInteger)n;
    }

    @Override
    public Date getDate(String column) {
        return TypeKit.toDate(this.getColumns().get(column));
    }

    @Override
    public LocalDateTime getLocalDateTime(String column) {
        return TypeKit.toLocalDateTime(this.getColumns().get(column));
    }

    @Override
    public Time getTime(String column) {
        return (Time)this.getColumns().get(column);
    }

    @Override
    public Timestamp getTimestamp(String column) {
        return (Timestamp)this.getColumns().get(column);
    }

    @Override
    public Double getDouble(String column) {
        return TypeKit.toDouble(this.getColumns().get(column));
    }

    @Override
    public Float getFloat(String column) {
        return TypeKit.toFloat(this.getColumns().get(column));
    }

    @Override
    public Short getShort(String column) {
        return TypeKit.toShort(this.getColumns().get(column));
    }

    @Override
    public Byte getByte(String column) {
        return TypeKit.toByte(this.getColumns().get(column));
    }

    @Override
    public Boolean getBoolean(String column) {
        return TypeKit.toBoolean(this.getColumns().get(column));
    }

    @Override
    public BigDecimal getBigDecimal(String column) {
        return TypeKit.toBigDecimal(this.getColumns().get(column));
    }

    @Override
    public byte[] getBytes(String column) {
        return (byte[])this.getColumns().get(column);
    }

    @Override
    public Number getNumber(String column) {
        return TypeKit.toNumber(this.getColumns().get(column));
    }

    public String toString() {
        if (this.columns == null) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Map.Entry<String, Object> e : this.getColumns().entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object value = e.getValue();
            if (value != null) {
                value = value.toString();
            }
            sb.append(e.getKey()).append(':').append(value);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Record)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.getColumns().equals(((Record)o).getColumns());
    }

    public int hashCode() {
        return this.getColumns().hashCode();
    }

    public String[] getColumnNames() {
        Set<String> attrNameSet = this.getColumns().keySet();
        return attrNameSet.toArray(new String[attrNameSet.size()]);
    }

    public Object[] getColumnValues() {
        Collection<Object> attrValueCollection = this.getColumns().values();
        return attrValueCollection.toArray(new Object[attrValueCollection.size()]);
    }

    @Override
    public Map<String, Object> toMap() {
        return this.getColumns();
    }

    @Override
    public Record put(Map<String, Object> map) {
        this.getColumns().putAll(map);
        return this;
    }

    @Override
    public Record put(String key, Object value) {
        this.getColumns().put(key, value);
        return this;
    }

    @Override
    public int size() {
        return this.columns != null ? this.columns.size() : 0;
    }
}

