/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.jfinal.json.Json;
import com.jfinal.kit.TimeKit;
import java.text.DateFormat;

public class Jackson
extends Json {
    private static boolean defaultGenerateNullValue = true;
    protected Boolean generateNullValue = null;
    protected static final ObjectMapper objectMapper = new ObjectMapper();

    public static void setDefaultGenerateNullValue(boolean defaultGenerateNullValue) {
        Jackson.defaultGenerateNullValue = defaultGenerateNullValue;
    }

    public Jackson setGenerateNullValue(boolean generateNullValue) {
        this.generateNullValue = generateNullValue;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static Jackson getJson() {
        return new Jackson();
    }

    @Override
    public String toJson(Object object) {
        try {
            boolean pnv;
            String dp;
            String string = dp = this.datePattern != null ? this.datePattern : this.getDefaultDatePattern();
            if (dp != null) {
                objectMapper.setDateFormat((DateFormat)TimeKit.getSimpleDateFormat(dp));
            }
            boolean bl = pnv = this.generateNullValue != null ? this.generateNullValue : defaultGenerateNullValue;
            if (!pnv) {
                objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            }
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    @Override
    public <T> T parse(String jsonString, Class<T> type) {
        try {
            return (T)objectMapper.readValue(jsonString, type);
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.findAndRegisterModules();
    }
}

