/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.auth.sign;

import com.jdcloud.sdk.http.SdkHttpRequest;
import com.jdcloud.sdk.http.handler.HandlerKeys;
import com.jdcloud.sdk.utils.HostNameUtils;
import com.jdcloud.sdk.utils.SignerUtils;
import java.util.Date;

public final class SignerRequestParams {
    private final SdkHttpRequest request;
    private final long signingDateTimeMilli;
    private final String scope;
    private final String regionName;
    private final String serviceName;
    private final String formattedSigningDateTime;
    private final String formattedSigningDate;
    private final String signingAlgorithm;

    public SignerRequestParams(SdkHttpRequest request, Date signingDateOverride, String regionNameOverride, String serviceName, String signingAlgorithm) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (signingAlgorithm == null) {
            throw new IllegalArgumentException("Signing Algorithm cannot be null");
        }
        this.request = request;
        this.signingDateTimeMilli = signingDateOverride != null ? signingDateOverride.getTime() : this.getSigningDate(request);
        this.formattedSigningDate = SignerUtils.formatDateStamp(this.signingDateTimeMilli);
        this.serviceName = serviceName;
        this.regionName = this.parseRegion(request, regionNameOverride);
        this.scope = this.generateScope(this.formattedSigningDate, this.serviceName, this.regionName);
        this.formattedSigningDateTime = SignerUtils.formatTimestamp(this.signingDateTimeMilli);
        this.signingAlgorithm = signingAlgorithm;
    }

    private String parseRegion(SdkHttpRequest request, String regionNameOverride) {
        return regionNameOverride != null ? regionNameOverride : HostNameUtils.parseRegion(request.getEndpoint().getHost(), this.serviceName);
    }

    private long getSigningDate(SdkHttpRequest request) {
        if (request.handlerContext(HandlerKeys.TIME_OFFSET) == null) {
            return System.currentTimeMillis();
        }
        return System.currentTimeMillis() - (long)request.handlerContext(HandlerKeys.TIME_OFFSET).intValue() * 1000L;
    }

    private String generateScope(String dateStamp, String serviceName, String regionName) {
        return dateStamp + "/" + regionName + "/" + serviceName + "/" + "jdcloud2_request";
    }

    public SdkHttpRequest getRequest() {
        return this.request;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFormattedSigningDateTime() {
        return this.formattedSigningDateTime;
    }

    public long getSigningDateTimeMilli() {
        return this.signingDateTimeMilli;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFormattedSigningDate() {
        return this.formattedSigningDate;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }
}

