/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.auth.sign;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.HttpRequest;
import com.jdcloud.sdk.auth.Credentials;
import com.jdcloud.sdk.auth.sign.ISignatureComposer;
import com.jdcloud.sdk.auth.sign.JdCloudSigner;
import com.jdcloud.sdk.client.SdkClientException;
import com.jdcloud.sdk.http.DefaultSdkHttpFullRequest;
import com.jdcloud.sdk.http.SdkHttpFullRequest;
import com.jdcloud.sdk.http.SdkHttpMethod;
import com.jdcloud.sdk.model.SignRequest;
import com.jdcloud.sdk.utils.SdkHttpUtils;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SignatureComposer
implements ISignatureComposer {
    @Override
    public void sign(SignRequest signRequest) throws SdkClientException {
        HttpRequest request = signRequest.getRequest();
        JdCloudSigner signer = new JdCloudSigner();
        signer.setRegionName(signRequest.getRegion());
        signer.setServiceName(signRequest.getServiceName());
        String nonceId = UUID.randomUUID().toString();
        DefaultSdkHttpFullRequest.Builder reqBuilder = DefaultSdkHttpFullRequest.builder().httpMethod(SdkHttpMethod.fromValue(request.getRequestMethod())).endpoint(URI.create(signRequest.getHost())).resourcePath(SdkHttpUtils.urlEncode(signRequest.getPath(), true)).header("X-Jdcloud-Nonce", nonceId).header("Content-Type", request.getHeaders().getContentType()).content(request.getContent() == null ? null : ((ByteArrayContent)request.getContent()).getInputStream());
        if (request.getUrl() != null && request.getUrl().size() > 0) {
            for (Map.Entry entry : request.getUrl().entrySet()) {
                if (entry.getValue() instanceof List) {
                    for (Object o : (List)entry.getValue()) {
                        reqBuilder.queryParameter((String)entry.getKey(), (String)o);
                    }
                    continue;
                }
                if (!(entry.getValue() instanceof String)) continue;
                reqBuilder.queryParameter((String)entry.getKey(), SdkHttpUtils.urlEncode((String)entry.getValue(), true));
            }
        }
        SdkHttpFullRequest signed = signer.sign(reqBuilder, new Credentials(signRequest.getCredentials().accessKeyId(), signRequest.getCredentials().secretAccessKey()));
        request.getHeaders().put("X-Jdcloud-Nonce", (Object)nonceId);
        request.getHeaders().put("X-Jdcloud-Date", (Object)signed.getHeaders().get("X-Jdcloud-Date").get(0));
        request.getHeaders().setAuthorization(signed.getHeaders().get("Authorization").get(0));
    }
}

