/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.auth.sign;

import com.jdcloud.sdk.auth.Credentials;
import com.jdcloud.sdk.auth.SessionCredentials;
import com.jdcloud.sdk.auth.sign.AbstractSigner;
import com.jdcloud.sdk.auth.sign.RegionSigner;
import com.jdcloud.sdk.auth.sign.ServiceSigner;
import com.jdcloud.sdk.auth.sign.SignerRequestParams;
import com.jdcloud.sdk.auth.sign.SigningAlgorithm;
import com.jdcloud.sdk.client.SdkClientException;
import com.jdcloud.sdk.http.SdkHttpFullRequest;
import com.jdcloud.sdk.http.SdkHttpRequest;
import com.jdcloud.sdk.utils.BinaryUtils;
import com.jdcloud.sdk.utils.SdkHttpUtils;
import com.jdcloud.sdk.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JdCloudSigner
extends AbstractSigner
implements ServiceSigner,
RegionSigner {
    private static final List<String> LIST_OF_HEADERS_TO_IGNORE_IN_LOWER_CASE = Arrays.asList("connection", "x-jdcloud-trace-id");
    protected String serviceName;
    protected String regionName;
    private Date overriddenDate;
    private boolean doubleUrlEncode;

    public String getRegionName() {
        return this.regionName;
    }

    @Override
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public JdCloudSigner() {
    }

    public JdCloudSigner(boolean doubleUrlEncode) {
        this.doubleUrlEncode = doubleUrlEncode;
    }

    public void setOverrideDate(Date overriddenDate) {
        this.overriddenDate = overriddenDate != null ? new Date(overriddenDate.getTime()) : null;
    }

    @Override
    public SdkHttpFullRequest sign(SdkHttpFullRequest.Builder builder, Credentials credentials) {
        return (SdkHttpFullRequest)this.doSign(builder, credentials).build();
    }

    private SdkHttpFullRequest.Builder doSign(SdkHttpFullRequest.Builder builder, Credentials credentials) {
        Credentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        if (sanitizedCredentials instanceof SessionCredentials) {
            this.addSessionCredentials(builder, (SessionCredentials)sanitizedCredentials);
        }
        SignerRequestParams signerParams = new SignerRequestParams(builder, this.overriddenDate, this.regionName, this.serviceName, "JDCLOUD2-HMAC-SHA256");
        this.addHostHeader(builder);
        builder.header("X-Jdcloud-Date", signerParams.getFormattedSigningDateTime());
        String contentSha256 = this.calculateContentHash(builder);
        String canonicalRequest = this.createCanonicalRequest(builder, contentSha256);
        String stringToSign = this.createStringToSign(canonicalRequest, signerParams);
        byte[] signingKey = this.deriveSigningKey(sanitizedCredentials, signerParams);
        byte[] signature = this.computeSignature(stringToSign, signingKey);
        builder.header("Authorization", this.buildAuthorizationHeader(builder, signature, sanitizedCredentials, signerParams));
        this.processRequestPayload(builder, signature, signingKey, signerParams);
        return builder;
    }

    private void addHostHeader(SdkHttpFullRequest.Builder mutableRequest) {
        URI endpoint = mutableRequest.getEndpoint();
        StringBuilder hostHeaderBuilder = new StringBuilder(endpoint.getHost());
        if (SdkHttpUtils.isUsingNonDefaultPort(endpoint)) {
            hostHeaderBuilder.append(":").append(endpoint.getPort());
        }
        mutableRequest.header("Host", hostHeaderBuilder.toString());
    }

    protected String calculateContentHash(SdkHttpFullRequest.Builder request) {
        InputStream payloadStream = this.getBinaryRequestPayloadStream(request.getContent());
        String contentSha256 = BinaryUtils.toHex(this.hash(payloadStream));
        try {
            payloadStream.reset();
        }
        catch (IOException e) {
            throw new SdkClientException("Unable to reset stream after calculating signature", e);
        }
        return contentSha256;
    }

    private String createCanonicalRequest(SdkHttpRequest request, String contentSha256) {
        String path = SdkHttpUtils.appendUri(request.getEndpoint().getPath(), request.getResourcePath());
        String canonicalRequest = request.getHttpMethod().toString() + "\n" + this.getCanonicalizedResourcePath(path, this.doubleUrlEncode) + "\n" + this.getCanonicalizedQueryString(request.getParameters()) + "\n" + this.getCanonicalizedHeaderString(request) + "\n" + this.getSignedHeadersString(request) + "\n" + contentSha256;
        return canonicalRequest;
    }

    private String getCanonicalizedHeaderString(SdkHttpRequest request) {
        ArrayList<String> sortedHeaders = new ArrayList<String>(request.getHeaders().keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        Map<String, List<String>> requestHeaders = request.getHeaders();
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            if (this.shouldExcludeHeaderFromSigning(header)) continue;
            String key = StringUtils.lowerCase(header);
            for (String headerValue : requestHeaders.get(header)) {
                StringUtils.appendCompactedString(buffer, key);
                buffer.append(":");
                if (headerValue != null) {
                    StringUtils.appendCompactedString(buffer, headerValue);
                }
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    private boolean shouldExcludeHeaderFromSigning(String header) {
        return LIST_OF_HEADERS_TO_IGNORE_IN_LOWER_CASE.contains(StringUtils.lowerCase(header));
    }

    private String getSignedHeadersString(SdkHttpRequest request) {
        ArrayList<String> sortedHeaders = new ArrayList<String>(request.getHeaders().keySet());
        Collections.sort(sortedHeaders, String.CASE_INSENSITIVE_ORDER);
        StringBuilder buffer = new StringBuilder();
        for (String header : sortedHeaders) {
            if (this.shouldExcludeHeaderFromSigning(header)) continue;
            if (buffer.length() > 0) {
                buffer.append(";");
            }
            buffer.append(StringUtils.lowerCase(header));
        }
        return buffer.toString();
    }

    private String createStringToSign(String canonicalRequest, SignerRequestParams signerParams) {
        String stringToSign = signerParams.getSigningAlgorithm() + "\n" + signerParams.getFormattedSigningDateTime() + "\n" + signerParams.getScope() + "\n" + BinaryUtils.toHex(this.hash(canonicalRequest));
        return stringToSign;
    }

    private byte[] deriveSigningKey(Credentials credentials, SignerRequestParams signerRequestParams) {
        byte[] signingKey = this.newSigningKey(credentials, signerRequestParams.getFormattedSigningDate(), signerRequestParams.getRegionName(), signerRequestParams.getServiceName());
        return signingKey;
    }

    private byte[] newSigningKey(Credentials credentials, String dateStamp, String regionName, String serviceName) {
        byte[] kSecret = ("JDCLOUD2" + credentials.secretAccessKey()).getBytes(Charset.forName("UTF-8"));
        byte[] kDate = this.sign(dateStamp, kSecret, SigningAlgorithm.HmacSHA256);
        byte[] kRegion = this.sign(regionName, kDate, SigningAlgorithm.HmacSHA256);
        byte[] kService = this.sign(serviceName, kRegion, SigningAlgorithm.HmacSHA256);
        return this.sign("jdcloud2_request", kService, SigningAlgorithm.HmacSHA256);
    }

    private byte[] computeSignature(String stringToSign, byte[] signingKey) {
        return this.sign(stringToSign.getBytes(Charset.forName("UTF-8")), signingKey, SigningAlgorithm.HmacSHA256);
    }

    private String buildAuthorizationHeader(SdkHttpRequest request, byte[] signature, Credentials credentials, SignerRequestParams signerParams) {
        String signingCredentials = credentials.accessKeyId() + "/" + signerParams.getScope();
        String credential = "Credential=" + signingCredentials;
        String signerHeaders = "SignedHeaders=" + this.getSignedHeadersString(request);
        String signatureHeader = "Signature=" + BinaryUtils.toHex(signature);
        return "JDCLOUD2-HMAC-SHA256" + " " + credential + ", " + signerHeaders + ", " + signatureHeader;
    }

    protected void processRequestPayload(SdkHttpFullRequest.Builder request, byte[] signature, byte[] signingKey, SignerRequestParams signerRequestParams) {
    }

    @Override
    protected void addSessionCredentials(SdkHttpFullRequest.Builder mutableRequest, SessionCredentials credentials) {
        mutableRequest.header("X-Jdcloud-Security-Token", credentials.sessionToken());
    }
}

