/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.role.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.db.api.DbOperatorApi;
import cn.stylefeng.roses.kernel.db.mp.datascope.UserRoleDataScopeApi;
import cn.stylefeng.roses.kernel.db.mp.datascope.config.DataScopeConfig;
import cn.stylefeng.roses.kernel.rule.enums.permission.DataScopeTypeEnum;
import cn.stylefeng.roses.kernel.sys.api.SysUserRoleServiceApi;
import cn.stylefeng.roses.kernel.sys.modular.role.entity.SysRole;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleDataScopeService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class UserRoleDataScopeImpl
implements UserRoleDataScopeApi {
    @Resource
    private SysUserRoleServiceApi sysUserRoleServiceApi;
    @Resource
    private SysRoleService sysRoleService;
    @Resource
    private SysRoleDataScopeService sysRoleDataScopeService;
    @Resource
    private DbOperatorApi dbOperatorApi;

    public DataScopeConfig getUserRoleDataScopeConfig() {
        LoginUser loginUser = LoginContext.me().getLoginUserNullable();
        if (loginUser == null) {
            return null;
        }
        List userRoleIdList = this.sysUserRoleServiceApi.getUserRoleIdListCurrentCompany(loginUser.getUserId(), loginUser.getCurrentOrgId());
        Long defaultRoleId = this.sysRoleService.getDefaultRoleId();
        if (userRoleIdList.size() > 1 && CollectionUtil.contains((Collection)userRoleIdList, (Object)defaultRoleId)) {
            userRoleIdList.remove(defaultRoleId);
        }
        Integer maxDataScope = 0;
        Long finalRoleId = null;
        List<SysRole> roleDataScopeType = this.sysRoleService.getRoleDataScopeType(userRoleIdList);
        for (SysRole sysRole : roleDataScopeType) {
            if (sysRole.getDataScopeType() <= maxDataScope) continue;
            maxDataScope = sysRole.getDataScopeType();
            finalRoleId = sysRole.getRoleId();
        }
        DataScopeConfig dataScopeConfig = new DataScopeConfig();
        dataScopeConfig.setDataScopeType(DataScopeTypeEnum.codeToEnum((Integer)maxDataScope));
        if (DataScopeTypeEnum.DEFINE.getCode().equals(maxDataScope)) {
            Set<Long> roleBindOrgIdList = this.sysRoleDataScopeService.getRoleBindOrgIdList(ListUtil.list((boolean)false, (Object[])new Long[]{finalRoleId}));
            dataScopeConfig.setSpecificOrgIds(new ArrayList<Long>(roleBindOrgIdList));
        }
        dataScopeConfig.setUserId(loginUser.getUserId());
        if (DataScopeTypeEnum.COMPANY_WITH_CHILD.getCode().equals(maxDataScope)) {
            Long currentUserCompanyId = LoginContext.me().getCurrentUserCompanyId();
            dataScopeConfig.setUserCompanyId(currentUserCompanyId);
        }
        if (DataScopeTypeEnum.DEPT.getCode().equals(maxDataScope) || DataScopeTypeEnum.DEPT_WITH_CHILD.getCode().equals(maxDataScope)) {
            dataScopeConfig.setUserDeptId(loginUser.getCurrentOrgId());
        }
        return dataScopeConfig;
    }
}

