/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.menu.util;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenu;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;

public class MenuOrderFixUtil {
    public static void fixOrder(List<SysMenu> sysMenus) {
        int digitCount;
        BigDecimal menuSort;
        if (ObjectUtil.isEmpty(sysMenus)) {
            return;
        }
        int maxDigitCount = 0;
        for (SysMenu sysMenu : sysMenus) {
            menuSort = sysMenu.getMenuSort();
            if (menuSort == null || (digitCount = MenuOrderFixUtil.getPointLeftDigitCount(menuSort)) <= maxDigitCount) continue;
            maxDigitCount = digitCount;
        }
        for (SysMenu sysMenu : sysMenus) {
            menuSort = sysMenu.getMenuSort();
            if (menuSort == null) {
                menuSort = new BigDecimal(0);
            }
            if ((digitCount = MenuOrderFixUtil.getPointLeftDigitCount(menuSort)) < maxDigitCount) {
                menuSort = menuSort.multiply(BigDecimal.valueOf(Math.pow(10.0, maxDigitCount - digitCount)));
            }
            sysMenu.setMenuSort(menuSort);
        }
        sysMenus.sort(Comparator.comparing(SysMenu::getMenuSort));
    }

    public static int getPointLeftDigitCount(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        String bigDecimalStr = bigDecimal.toString();
        int decimalIndex = bigDecimalStr.indexOf(46);
        return decimalIndex >= 0 ? decimalIndex : bigDecimalStr.length();
    }
}

