/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.menu.factory;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenu;
import java.math.BigDecimal;
import java.util.List;

public class MenuTreeFactory {
    public static void updateSort(List<SysMenu> tree, Integer baseNumber) {
        if (baseNumber == null || baseNumber == 0) {
            baseNumber = 1;
        }
        BigDecimal newBaseNumber = new BigDecimal(baseNumber * 100);
        for (SysMenu sysMenu : tree) {
            newBaseNumber = newBaseNumber.add(new BigDecimal(1));
            sysMenu.setMenuSort(newBaseNumber);
            List<SysMenu> children = sysMenu.getChildren();
            if (children == null || children.size() <= 0) continue;
            MenuTreeFactory.updateSort(children, newBaseNumber.intValue());
        }
    }

    public static void collectTreeTasks(List<SysMenu> sysMenuTree, List<SysMenu> totalMenuList) {
        if (ObjectUtil.isEmpty(sysMenuTree)) {
            return;
        }
        for (SysMenu sysMenu : sysMenuTree) {
            totalMenuList.add(sysMenu);
            if (!ObjectUtil.isNotEmpty(sysMenu.getChildren())) continue;
            MenuTreeFactory.collectTreeTasks(sysMenu.getChildren(), totalMenuList);
        }
    }

    public static void fillParentId(Long parentMenuId, List<SysMenu> menuTreeList) {
        if (ObjectUtil.isEmpty(menuTreeList)) {
            return;
        }
        for (SysMenu sysMenu : menuTreeList) {
            sysMenu.setMenuParentId(parentMenuId);
            if (!ObjectUtil.isNotEmpty(sysMenu.getChildren())) continue;
            MenuTreeFactory.fillParentId(sysMenu.getMenuId(), sysMenu.getChildren());
        }
    }
}

