/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.login.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.sys.api.SysUserOrgServiceApi;
import cn.stylefeng.roses.kernel.sys.api.SysUserRoleServiceApi;
import cn.stylefeng.roses.kernel.sys.api.SysUserServiceApi;
import cn.stylefeng.roses.kernel.sys.api.exception.enums.OrgExceptionEnum;
import cn.stylefeng.roses.kernel.sys.api.exception.enums.RoleExceptionEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.SimpleUserDTO;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.UserOrgDTO;
import cn.stylefeng.roses.kernel.sys.modular.app.service.SysAppService;
import cn.stylefeng.roses.kernel.sys.modular.login.expander.WebSocketConfigExpander;
import cn.stylefeng.roses.kernel.sys.modular.login.pojo.IndexUserAppInfo;
import cn.stylefeng.roses.kernel.sys.modular.login.pojo.IndexUserMenuInfo;
import cn.stylefeng.roses.kernel.sys.modular.login.pojo.IndexUserOrgInfo;
import cn.stylefeng.roses.kernel.sys.modular.login.pojo.UpdateUserOrgAppRequest;
import cn.stylefeng.roses.kernel.sys.modular.login.pojo.UserIndexInfo;
import cn.stylefeng.roses.kernel.sys.modular.menu.entity.SysMenu;
import cn.stylefeng.roses.kernel.sys.modular.menu.factory.MenuFactory;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.menu.service.SysMenuService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuOptionsService;
import cn.stylefeng.roses.kernel.sys.modular.role.service.SysRoleMenuService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class UserIndexInfoService {
    @Resource
    private SysUserServiceApi sysUserServiceApi;
    @Resource
    private SysUserOrgServiceApi sysUserOrgServiceApi;
    @Resource
    private SysUserRoleServiceApi sysUserRoleServiceApi;
    @Resource
    private SysRoleMenuService sysRoleMenuService;
    @Resource
    private SysRoleMenuOptionsService sysRoleMenuOptionsService;
    @Resource
    private SysMenuService sysMenuService;
    @Resource
    private SysMenuOptionsService sysMenuOptionsService;
    @Resource
    private SysAppService sysAppService;
    @Resource
    private SessionManagerApi sessionManagerApi;

    public UserIndexInfo getUserIndexInfo() {
        UserIndexInfo userIndexInfo = new UserIndexInfo();
        userIndexInfo.setSuperAdminFlag(LoginContext.me().getSuperAdminFlag());
        LoginUser loginUser = LoginContext.me().getLoginUser();
        this.fillUserBaseInfo(loginUser.getUserId(), userIndexInfo);
        List<IndexUserOrgInfo> indexUserOrgInfos = this.fillUserOrgInfo(loginUser);
        userIndexInfo.setUserOrgInfoList(indexUserOrgInfos);
        List<SysMenu> userMenuList = this.fillUserPermissionCodeList(loginUser, userIndexInfo);
        this.fillUserAppList(loginUser, userIndexInfo, userMenuList);
        this.fillWebSocketUrl(loginUser, userIndexInfo);
        this.sessionManagerApi.updateSession(loginUser.getToken(), loginUser);
        return userIndexInfo;
    }

    public void updateUserOrgOrApp(UpdateUserOrgAppRequest updateUserOrgAppRequest) {
        LoginUser loginUser = LoginContext.me().getLoginUser();
        if (updateUserOrgAppRequest.getNewOrgId() != null) {
            boolean result = this.sysUserOrgServiceApi.validateUserOrgAuth(updateUserOrgAppRequest.getNewOrgId(), loginUser.getUserId());
            if (!result) {
                throw new ServiceException((AbstractExceptionEnum)OrgExceptionEnum.UPDATE_LOGIN_USER_ORG_ERROR);
            }
            loginUser.setCurrentOrgId(updateUserOrgAppRequest.getNewOrgId());
            Long positionId = this.sysUserOrgServiceApi.getUserOrgPositionId(loginUser.getUserId(), updateUserOrgAppRequest.getNewOrgId());
            loginUser.setCurrentPositionId(positionId);
        }
        if (updateUserOrgAppRequest.getNewAppId() != null) {
            this.validateUserHaveAppId(loginUser, updateUserOrgAppRequest.getNewAppId());
            loginUser.setCurrentAppId(updateUserOrgAppRequest.getNewAppId());
        }
        this.sessionManagerApi.updateSession(loginUser.getToken(), loginUser);
    }

    public List<IndexUserOrgInfo> fillUserOrgInfo(LoginUser loginUser) {
        ArrayList<IndexUserOrgInfo> resultUserOrg = new ArrayList<IndexUserOrgInfo>();
        Long currentOrgId = loginUser.getCurrentOrgId();
        List userOrgList = this.sysUserOrgServiceApi.getUserOrgList(loginUser.getUserId(), false);
        if (ObjectUtil.isEmpty((Object)userOrgList)) {
            return resultUserOrg;
        }
        if (currentOrgId != null) {
            boolean haveChangeDept = true;
            for (UserOrgDTO userOrgDTO : userOrgList) {
                Long companyId = userOrgDTO.getCompanyId();
                Long deptId = userOrgDTO.getDeptId();
                if (!currentOrgId.equals(companyId) && !currentOrgId.equals(deptId)) continue;
                haveChangeDept = false;
            }
            if (haveChangeDept) {
                currentOrgId = null;
            }
        }
        for (UserOrgDTO userOrgItem : userOrgList) {
            IndexUserOrgInfo indexUserOrgInfo = new IndexUserOrgInfo();
            indexUserOrgInfo.setUserId(loginUser.getUserId());
            if (ObjectUtil.isNotEmpty((Object)userOrgItem.getDeptId())) {
                indexUserOrgInfo.setOrgId(userOrgItem.getDeptId());
            } else {
                indexUserOrgInfo.setOrgId(userOrgItem.getCompanyId());
            }
            indexUserOrgInfo.setCompanyId(userOrgItem.getCompanyId());
            indexUserOrgInfo.setCompanyName(userOrgItem.getCompanyName());
            indexUserOrgInfo.setDeptName(userOrgItem.getDeptName());
            indexUserOrgInfo.setPositionId(userOrgItem.getPositionId());
            indexUserOrgInfo.setPositionName(userOrgItem.getPositionName());
            indexUserOrgInfo.setMainFlag(YesOrNotEnum.Y.getCode().equals(userOrgItem.getMainFlag()));
            resultUserOrg.add(indexUserOrgInfo);
        }
        if (currentOrgId == null) {
            for (IndexUserOrgInfo indexUserOrgInfo : resultUserOrg) {
                indexUserOrgInfo.setCurrentSelectFlag(indexUserOrgInfo.getMainFlag());
                if (!indexUserOrgInfo.getMainFlag().booleanValue()) continue;
                loginUser.setCurrentOrgId(indexUserOrgInfo.getOrgId());
                loginUser.setCurrentPositionId(indexUserOrgInfo.getPositionId());
            }
        } else {
            for (IndexUserOrgInfo indexUserOrgInfo : resultUserOrg) {
                indexUserOrgInfo.setCurrentSelectFlag(indexUserOrgInfo.getOrgId().equals(currentOrgId));
            }
        }
        return resultUserOrg;
    }

    private void fillUserBaseInfo(Long userId, UserIndexInfo userIndexInfo) {
        SimpleUserDTO simpleUserDTO = this.sysUserServiceApi.getUserInfoByUserId(userId);
        userIndexInfo.setUserId(simpleUserDTO.getUserId());
        userIndexInfo.setRealName(simpleUserDTO.getRealName());
        userIndexInfo.setAvatarUrl(simpleUserDTO.getAvatarUrl());
    }

    private List<SysMenu> fillUserPermissionCodeList(LoginUser loginUser, UserIndexInfo userIndexInfo) {
        Long userId = loginUser.getUserId();
        List roleIdList = null;
        List userCurrentOrgList = userIndexInfo.getUserOrgInfoList().stream().filter(IndexUserOrgInfo::getCurrentSelectFlag).map(IndexUserOrgInfo::getOrgId).collect(Collectors.toList());
        roleIdList = ObjectUtil.isEmpty(userCurrentOrgList) ? this.sysUserRoleServiceApi.getUserRoleIdListCurrentCompany(userId, null) : this.sysUserRoleServiceApi.getUserRoleIdListCurrentCompany(userId, (Long)userCurrentOrgList.get(0));
        if (ObjectUtil.isEmpty((Object)roleIdList)) {
            userIndexInfo.setPermissionCodeList(new HashSet<String>());
            return new ArrayList<SysMenu>();
        }
        List<Long> menuIdList = this.sysRoleMenuService.getRoleBindMenuIdList(roleIdList);
        List<Long> menuOptionsIdList = this.sysRoleMenuOptionsService.getRoleBindMenuOptionsIdList(roleIdList);
        Set<String> permissionCodeList = new HashSet<String>();
        List<SysMenu> userMenuList = this.sysMenuService.getIndexMenuInfoList(menuIdList);
        Set menuCodeList = userMenuList.stream().map(SysMenu::getMenuCode).collect(Collectors.toSet());
        permissionCodeList.addAll(menuCodeList);
        Set<Long> needToAddMenuIds = MenuFactory.getMenuParentIds(userMenuList);
        if (ObjectUtil.isNotEmpty(needToAddMenuIds)) {
            List<SysMenu> needToAddMenuList = this.sysMenuService.getIndexMenuInfoList(ListUtil.list((boolean)true, needToAddMenuIds));
            userMenuList.addAll(needToAddMenuList);
            Set needToAddCodes = needToAddMenuList.stream().map(SysMenu::getMenuCode).collect(Collectors.toSet());
            permissionCodeList.addAll(needToAddCodes);
        }
        List<String> optionsCodeList = this.sysMenuOptionsService.getOptionsCodeList(menuOptionsIdList);
        permissionCodeList.addAll(optionsCodeList);
        if (ObjectUtil.isNotEmpty(permissionCodeList)) {
            permissionCodeList = permissionCodeList.stream().map(String::toUpperCase).collect(Collectors.toSet());
        }
        userIndexInfo.setPermissionCodeList(permissionCodeList);
        userMenuList.sort(Comparator.comparing(SysMenu::getMenuSort));
        return userMenuList;
    }

    private void fillUserAppList(LoginUser loginUser, UserIndexInfo userIndexInfo, List<SysMenu> userMenuList) {
        if (ObjectUtil.isEmpty(userMenuList)) {
            return;
        }
        Set<Long> userAppIds = userMenuList.stream().map(SysMenu::getAppId).collect(Collectors.toSet());
        List<IndexUserAppInfo> indexUserAppList = this.sysAppService.getIndexUserAppList(userAppIds);
        if (ObjectUtil.isEmpty((Object)loginUser.getCurrentAppId())) {
            indexUserAppList.get(0).setCurrentSelectFlag(true);
            loginUser.setCurrentAppId(indexUserAppList.get(0).getAppId());
        } else {
            for (IndexUserAppInfo indexUserAppInfo : indexUserAppList) {
                if (!indexUserAppInfo.getAppId().equals(loginUser.getCurrentAppId())) continue;
                indexUserAppInfo.setCurrentSelectFlag(true);
            }
        }
        for (IndexUserAppInfo indexUserAppInfo : indexUserAppList) {
            List<IndexUserMenuInfo> appMenuList = indexUserAppInfo.getMenuList();
            if (ObjectUtil.isEmpty(appMenuList)) {
                appMenuList = new ArrayList<IndexUserMenuInfo>();
            }
            for (SysMenu userMenuItem : userMenuList) {
                if (!userMenuItem.getAppId().equals(indexUserAppInfo.getAppId())) continue;
                IndexUserMenuInfo indexUserMenuInfo = UserIndexInfoService.createIndexUserMenuInfo(userMenuItem);
                appMenuList.add(indexUserMenuInfo);
            }
            if (ObjectUtil.isEmpty(appMenuList)) {
                indexUserAppInfo.setMenuList(appMenuList);
                continue;
            }
            List appMenuTree = new DefaultTreeBuildFactory().doTreeBuild(appMenuList);
            indexUserAppInfo.setMenuList(appMenuTree);
        }
        userIndexInfo.setUserAppInfoList(indexUserAppList);
    }

    private void fillWebSocketUrl(LoginUser loginUser, UserIndexInfo userIndexInfo) {
        String webSocketWsUrl = WebSocketConfigExpander.getWebSocketWsUrl();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("token", loginUser.getToken());
        webSocketWsUrl = StrUtil.format((CharSequence)webSocketWsUrl, params);
        userIndexInfo.setWebsocketUrl(webSocketWsUrl);
    }

    private void validateUserHaveAppId(LoginUser loginUser, Long appId) {
        Long userId = loginUser.getUserId();
        List userRoleIdList = this.sysUserRoleServiceApi.getUserRoleIdList(userId);
        boolean permissionFlag = this.sysRoleMenuService.validateRoleHaveAppIdPermission(userRoleIdList, appId);
        if (!permissionFlag) {
            throw new ServiceException((AbstractExceptionEnum)RoleExceptionEnum.USER_HAVE_NO_APP_ID);
        }
    }

    private static IndexUserMenuInfo createIndexUserMenuInfo(SysMenu userMenuItem) {
        IndexUserMenuInfo indexUserMenuInfo = new IndexUserMenuInfo();
        indexUserMenuInfo.setMenuId(userMenuItem.getMenuId());
        indexUserMenuInfo.setMenuParentId(userMenuItem.getMenuParentId());
        indexUserMenuInfo.setMenuType(userMenuItem.getMenuType());
        indexUserMenuInfo.setTitle(userMenuItem.getMenuName());
        indexUserMenuInfo.setIcon(userMenuItem.getAntdvIcon());
        indexUserMenuInfo.setHide(YesOrNotEnum.N.getCode().equals(userMenuItem.getAntdvVisible()));
        indexUserMenuInfo.setActive(userMenuItem.getAntdvActiveUrl());
        indexUserMenuInfo.setPath(userMenuItem.getAntdvRouter());
        indexUserMenuInfo.setComponent(userMenuItem.getAntdvComponent());
        indexUserMenuInfo.setSortNumber(userMenuItem.getMenuSort());
        indexUserMenuInfo.setAppDesignBusinessId(userMenuItem.getAppDesignBusinessId());
        indexUserMenuInfo.setAppDesignViewId(userMenuItem.getAppDesignViewId());
        return indexUserMenuInfo;
    }
}

