/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.user.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.DbOperatorApi;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.dsctn.api.context.DataSourceContext;
import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveOrgCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveUserCallbackApi;
import cn.stylefeng.roses.kernel.sys.api.exception.enums.OrgExceptionEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.UserOrgDTO;
import cn.stylefeng.roses.kernel.sys.modular.user.entity.SysUserOrg;
import cn.stylefeng.roses.kernel.sys.modular.user.enums.SysUserOrgExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.user.factory.UserOrgFactory;
import cn.stylefeng.roses.kernel.sys.modular.user.mapper.SysUserOrgMapper;
import cn.stylefeng.roses.kernel.sys.modular.user.pojo.request.SysUserOrgRequest;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserOrgService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserOrgServiceImpl
extends ServiceImpl<SysUserOrgMapper, SysUserOrg>
implements SysUserOrgService,
RemoveOrgCallbackApi,
RemoveUserCallbackApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysUserOrgServiceImpl.class);
    @Resource
    private DbOperatorApi dbOperatorApi;

    @Override
    public void add(SysUserOrgRequest sysUserOrgRequest) {
        if (YesOrNotEnum.Y.getCode().equals(sysUserOrgRequest.getMainFlag())) {
            LambdaQueryWrapper sysUserOrgLambdaQueryWrapper = new LambdaQueryWrapper();
            sysUserOrgLambdaQueryWrapper.eq(SysUserOrg::getUserId, (Object)sysUserOrgRequest.getUserId());
            sysUserOrgLambdaQueryWrapper.eq(SysUserOrg::getMainFlag, (Object)YesOrNotEnum.Y.getCode());
            long count = this.count((Wrapper)sysUserOrgLambdaQueryWrapper);
            if (count > 0L) {
                throw new ServiceException((AbstractExceptionEnum)SysUserOrgExceptionEnum.MAIN_FLAG_ERROR);
            }
        }
        SysUserOrg sysUserOrg = new SysUserOrg();
        BeanUtil.copyProperties((Object)((Object)sysUserOrgRequest), (Object)((Object)sysUserOrg), (String[])new String[0]);
        this.save((Object)sysUserOrg);
    }

    @Override
    public void del(SysUserOrgRequest sysUserOrgRequest) {
        SysUserOrg sysUserOrg = this.querySysUserOrg(sysUserOrgRequest);
        this.removeById(sysUserOrg.getUserOrgId());
    }

    @Override
    public void edit(SysUserOrgRequest sysUserOrgRequest) {
        SysUserOrg sysUserOrg = this.querySysUserOrg(sysUserOrgRequest);
        BeanUtil.copyProperties((Object)((Object)sysUserOrgRequest), (Object)((Object)sysUserOrg), (String[])new String[0]);
        this.updateById((Object)sysUserOrg);
    }

    @Override
    public SysUserOrg detail(SysUserOrgRequest sysUserOrgRequest) {
        return this.querySysUserOrg(sysUserOrgRequest);
    }

    @Override
    public PageResult<SysUserOrg> findPage(SysUserOrgRequest sysUserOrgRequest) {
        LambdaQueryWrapper<SysUserOrg> wrapper = this.createWrapper(sysUserOrgRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUserOrg(Long userId, List<SysUserOrg> userOrgList) {
        List<SysUserOrg> sysUserOrgResult = this.validateUserOrgParam(userId, userOrgList);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUserOrg::getUserId, (Object)userId);
        this.remove((Wrapper)wrapper);
        this.saveBatch(sysUserOrgResult);
    }

    @Override
    public SysUserOrg getUserOrgInfo(Long userId, Long orgId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUserOrg::getUserId, (Object)userId);
        wrapper.eq(SysUserOrg::getOrgId, (Object)orgId);
        return (SysUserOrg)((Object)this.getOne((Wrapper)wrapper, false));
    }

    @Override
    public void removeUserOrgLink(Long userId, Long orgId) {
        LambdaUpdateWrapper sysUserOrgLambdaUpdateWrapper = new LambdaUpdateWrapper();
        sysUserOrgLambdaUpdateWrapper.eq(SysUserOrg::getUserId, (Object)userId);
        sysUserOrgLambdaUpdateWrapper.eq(SysUserOrg::getOrgId, (Object)orgId);
        this.remove((Wrapper)sysUserOrgLambdaUpdateWrapper);
    }

    @Override
    public void deleteAllOrgBind(SysUserOrgRequest sysUserOrgRequest) {
        LambdaQueryWrapper<SysUserOrg> wrapper = this.createWrapper(sysUserOrgRequest);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public void disableAllOrgStatus(Long userId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(SysUserOrg::getUserId, (Object)userId);
        updateWrapper.set(SysUserOrg::getStatusFlag, (Object)StatusEnum.DISABLE.getCode());
        this.update((Wrapper)updateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void quickBatchSaveUserOrg(List<SysUserOrg> batchUserOrg) {
        if (DbTypeEnum.MYSQL.equals((Object)DataSourceContext.me().getCurrentDbType())) {
            ((SysUserOrgMapper)this.getBaseMapper()).insertBatchSomeColumn(batchUserOrg);
        } else {
            this.saveBatch(batchUserOrg);
        }
    }

    @Override
    public List<SysUserOrg> findList(SysUserOrgRequest sysUserOrgRequest) {
        LambdaQueryWrapper<SysUserOrg> wrapper = this.createWrapper(sysUserOrgRequest);
        return this.list((Wrapper)wrapper);
    }

    public void validateHaveOrgBind(Set<Long> beRemovedOrgIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysUserOrg::getOrgId, beRemovedOrgIdList);
        long count = this.count((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new ServiceException((AbstractExceptionEnum)OrgExceptionEnum.DELETE_ORGANIZATION_ERROR);
        }
    }

    public void removeOrgAction(Set<Long> beRemovedOrgIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysUserOrg::getOrgId, beRemovedOrgIdList);
        this.remove((Wrapper)queryWrapper);
    }

    public void validateHaveUserBind(Set<Long> beRemovedUserIdList) {
    }

    public void removeUserAction(Set<Long> beRemovedUserIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysUserOrg::getUserId, beRemovedUserIdList);
        this.remove((Wrapper)queryWrapper);
    }

    public UserOrgDTO getUserMainOrgInfo(Long userId) {
        if (userId == null) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserOrg::getUserId, (Object)userId);
        queryWrapper.eq(SysUserOrg::getMainFlag, (Object)YesOrNotEnum.Y.getCode());
        List sysUserOrgList = this.list((Wrapper)queryWrapper);
        if (ObjectUtil.isEmpty((Object)sysUserOrgList)) {
            return null;
        }
        if (sysUserOrgList.size() > 1) {
            log.warn(StrUtil.format((CharSequence)SysUserOrgExceptionEnum.MAIN_FLAG_COUNT_ERROR.getUserTip(), (Object[])new Object[]{userId}));
        }
        SysUserOrg sysUserOrg = (SysUserOrg)((Object)sysUserOrgList.get(0));
        return UserOrgFactory.createUserOrgDetailInfo(sysUserOrg);
    }

    public List<UserOrgDTO> getUserOrgList(Long userId, boolean getTotalOrg) {
        if (userId == null) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserOrg::getUserId, (Object)userId);
        if (!getTotalOrg) {
            queryWrapper.eq(SysUserOrg::getStatusFlag, (Object)StatusEnum.ENABLE.getCode());
        }
        queryWrapper.orderByDesc(SysUserOrg::getMainFlag);
        List sysUserOrgList = this.list((Wrapper)queryWrapper);
        ArrayList<UserOrgDTO> userOrgDTOS = new ArrayList<UserOrgDTO>();
        for (SysUserOrg sysUserOrg : sysUserOrgList) {
            UserOrgDTO userOrgDetailInfo = UserOrgFactory.createUserOrgDetailInfo(sysUserOrg);
            userOrgDTOS.add(userOrgDetailInfo);
        }
        return userOrgDTOS;
    }

    public List<Long> getUserOrgIdList(Long userId, boolean getTotalOrg) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserOrg::getUserId, (Object)userId);
        if (!getTotalOrg) {
            queryWrapper.eq(SysUserOrg::getStatusFlag, (Object)StatusEnum.ENABLE.getCode());
        }
        queryWrapper.select(new SFunction[]{SysUserOrg::getOrgId});
        List sysUserOrgList = this.list((Wrapper)queryWrapper);
        if (ObjectUtil.isEmpty((Object)sysUserOrgList)) {
            return new ArrayList<Long>();
        }
        return sysUserOrgList.stream().map(SysUserOrg::getOrgId).collect(Collectors.toList());
    }

    public List<Long> getOrgUserIdList(Long orgId, Boolean containSubOrgFlag) {
        if (!containSubOrgFlag.booleanValue()) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysUserOrg::getOrgId, (Object)orgId);
            queryWrapper.select(new SFunction[]{SysUserOrg::getUserId});
            List list2 = this.list((Wrapper)queryWrapper);
            return list2.stream().map(SysUserOrg::getUserId).collect(Collectors.toList());
        }
        Set subOrgIdList = this.dbOperatorApi.findSubListByParentId("sys_hr_organization", "org_pids", "org_id", orgId);
        subOrgIdList.add(orgId);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysUserOrg::getOrgId, (Collection)subOrgIdList);
        queryWrapper.select(new SFunction[]{SysUserOrg::getUserId});
        List list3 = this.list((Wrapper)queryWrapper);
        return list3.stream().map(SysUserOrg::getUserId).collect(Collectors.toList());
    }

    public boolean validateUserOrgAuth(Long orgId, Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserOrg::getUserId, (Object)userId);
        queryWrapper.eq(SysUserOrg::getOrgId, (Object)orgId);
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    public List<Long> getPositionUserList(Long orgId, Long positionId) {
        SysUserOrgRequest sysUserOrgRequest = new SysUserOrgRequest();
        sysUserOrgRequest.setOrgId(orgId);
        sysUserOrgRequest.setPositionId(positionId);
        LambdaQueryWrapper<SysUserOrg> wrapper = this.createWrapper(sysUserOrgRequest);
        wrapper.select(new SFunction[]{SysUserOrg::getUserId});
        List list2 = this.list((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)list2)) {
            return list2.stream().map(SysUserOrg::getUserId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    public Long getUserOrgPositionId(Long userId, Long orgId) {
        if (ObjectUtil.isEmpty((Object)userId) || ObjectUtil.isEmpty((Object)orgId)) {
            return null;
        }
        SysUserOrgRequest sysUserOrgRequest = new SysUserOrgRequest();
        sysUserOrgRequest.setUserId(userId);
        sysUserOrgRequest.setOrgId(orgId);
        LambdaQueryWrapper<SysUserOrg> wrapper = this.createWrapper(sysUserOrgRequest);
        wrapper.select(new SFunction[]{SysUserOrg::getPositionId});
        SysUserOrg sysUserOrg = (SysUserOrg)((Object)this.getOne((Wrapper)wrapper, false));
        if (sysUserOrg != null) {
            return sysUserOrg.getPositionId();
        }
        return null;
    }

    public Set<Long> getOrgUserIdList(Set<Long> orgIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysUserOrg::getOrgId, orgIdList);
        queryWrapper.select(new SFunction[]{SysUserOrg::getUserId});
        List list2 = this.list((Wrapper)queryWrapper);
        return list2.stream().map(SysUserOrg::getUserId).collect(Collectors.toSet());
    }

    public void updateOtherOrgStatus(Long userId, Long excludeOrgId, Integer statusFlag) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(SysUserOrg::getUserId, (Object)userId);
        if (ObjectUtil.isNotEmpty((Object)excludeOrgId)) {
            updateWrapper.ne(SysUserOrg::getOrgId, (Object)excludeOrgId);
        }
        updateWrapper.set(SysUserOrg::getStatusFlag, (Object)statusFlag);
        this.update((Wrapper)updateWrapper);
    }

    private SysUserOrg querySysUserOrg(SysUserOrgRequest sysUserOrgRequest) {
        SysUserOrg sysUserOrg = (SysUserOrg)((Object)this.getById(sysUserOrgRequest.getUserOrgId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysUserOrg))) {
            throw new ServiceException((AbstractExceptionEnum)SysUserOrgExceptionEnum.SYS_USER_ORG_NOT_EXISTED);
        }
        return sysUserOrg;
    }

    private LambdaQueryWrapper<SysUserOrg> createWrapper(SysUserOrgRequest sysUserOrgRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long userId = sysUserOrgRequest.getUserId();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)userId), SysUserOrg::getUserId, (Object)userId);
        Long orgId = sysUserOrgRequest.getOrgId();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)orgId), SysUserOrg::getOrgId, (Object)orgId);
        Long positionId = sysUserOrgRequest.getPositionId();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)positionId), SysUserOrg::getPositionId, (Object)positionId);
        return queryWrapper;
    }

    private List<SysUserOrg> validateUserOrgParam(Long userId, List<SysUserOrg> userOrgList) {
        int mainFlagCount = 0;
        for (SysUserOrg sysUserOrg : userOrgList) {
            if (ObjectUtil.isEmpty((Object)sysUserOrg.getOrgId()) || ObjectUtil.isEmpty((Object)sysUserOrg.getPositionId()) || ObjectUtil.isEmpty((Object)sysUserOrg.getMainFlag())) {
                throw new ServiceException((AbstractExceptionEnum)SysUserOrgExceptionEnum.EMPTY_PARAM);
            }
            if (YesOrNotEnum.Y.getCode().equals(sysUserOrg.getMainFlag())) {
                ++mainFlagCount;
            }
            sysUserOrg.setUserId(userId);
        }
        if (mainFlagCount > 1 || mainFlagCount == 0) {
            throw new ServiceException((AbstractExceptionEnum)SysUserOrgExceptionEnum.MAIN_FLAG_ERROR);
        }
        return userOrgList;
    }
}

