/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.user.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.dsctn.api.context.DataSourceContext;
import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import cn.stylefeng.roses.kernel.sys.api.callback.RemoveUserCallbackApi;
import cn.stylefeng.roses.kernel.sys.modular.user.entity.SysUserCertificate;
import cn.stylefeng.roses.kernel.sys.modular.user.mapper.SysUserCertificateMapper;
import cn.stylefeng.roses.kernel.sys.modular.user.pojo.response.SysUserCertificateResponse;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserCertificateService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserCertificateServiceImpl
extends ServiceImpl<SysUserCertificateMapper, SysUserCertificate>
implements SysUserCertificateService,
RemoveUserCallbackApi {
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUserCertificate(Long userId, List<SysUserCertificate> sysUserCertificateList) {
        if (ObjectUtil.isEmpty((Object)userId) || ObjectUtil.isEmpty(sysUserCertificateList)) {
            return;
        }
        sysUserCertificateList.forEach(sysUserCertificate -> sysUserCertificate.setUserId(userId));
        LambdaQueryWrapper deleteWrapper = new LambdaQueryWrapper();
        deleteWrapper.eq(SysUserCertificate::getUserId, (Object)userId);
        this.remove((Wrapper)deleteWrapper);
        if (DbTypeEnum.MYSQL.equals((Object)DataSourceContext.me().getCurrentDbType())) {
            ((SysUserCertificateMapper)this.getBaseMapper()).insertBatchSomeColumn(sysUserCertificateList);
        } else {
            this.saveBatch(sysUserCertificateList);
        }
    }

    @Override
    public List<SysUserCertificateResponse> getUserCertificateList(Long userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUserCertificate::getUserId, (Object)userId);
        queryWrapper.select(new SFunction[]{SysUserCertificate::getCertificateType, SysUserCertificate::getCertificateNo, SysUserCertificate::getDateIssued, SysUserCertificate::getDateExpires, SysUserCertificate::getIssuingAuthority, SysUserCertificate::getAttachmentId});
        List sysUserCertificateList = this.list((Wrapper)queryWrapper);
        if (ObjectUtil.isEmpty((Object)sysUserCertificateList)) {
            return new ArrayList<SysUserCertificateResponse>();
        }
        return BeanUtil.copyToList((Collection)sysUserCertificateList, SysUserCertificateResponse.class);
    }

    public void validateHaveUserBind(Set<Long> beRemovedUserIdList) {
    }

    public void removeUserAction(Set<Long> beRemovedUserIdList) {
        LambdaQueryWrapper deleteWrapper = new LambdaQueryWrapper();
        deleteWrapper.in(SysUserCertificate::getUserId, beRemovedUserIdList);
        this.remove((Wrapper)deleteWrapper);
    }
}

