/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.user.factory;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.sys.api.enums.role.RoleTypeEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.role.SysRoleDTO;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.UserOrgDTO;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.newrole.NewUserRoleBindItem;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.newrole.NewUserRoleBindResponse;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.newrole.UserRoleDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RoleAssignFactory {
    public static List<NewUserRoleBindResponse> createBaseResponse(List<UserOrgDTO> userOrgDTOList) {
        ArrayList<NewUserRoleBindResponse> baseResponse = new ArrayList<NewUserRoleBindResponse>();
        if (ObjectUtil.isEmpty(userOrgDTOList)) {
            return baseResponse;
        }
        for (UserOrgDTO userOrgDTO : userOrgDTOList) {
            NewUserRoleBindResponse newUserRoleBindResponse = new NewUserRoleBindResponse();
            Long orgId = userOrgDTO.getDeptId();
            if (orgId == null) {
                orgId = userOrgDTO.getCompanyId();
            }
            newUserRoleBindResponse.setOrgId(orgId);
            String orgInfoName = userOrgDTO.getCompanyName() + "/" + (String)(userOrgDTO.getDeptName() == null ? "" : userOrgDTO.getDeptName() + "/") + userOrgDTO.getPositionName();
            newUserRoleBindResponse.setOrgName(orgInfoName);
            newUserRoleBindResponse.setEnableThisOrg(Boolean.valueOf(StatusEnum.ENABLE.getCode().equals(userOrgDTO.getStatusFlag())));
            newUserRoleBindResponse.setCompanyId(userOrgDTO.getCompanyId());
            baseResponse.add(newUserRoleBindResponse);
        }
        return baseResponse;
    }

    public static void fillRoleSelectList(List<NewUserRoleBindResponse> baseResponse, List<SysRoleDTO> businessRoleAndCompanyRole) {
        List businessRoleList = businessRoleAndCompanyRole.stream().filter(i -> i.getRoleType().equals(RoleTypeEnum.BUSINESS_ROLE.getCode())).collect(Collectors.toList());
        for (NewUserRoleBindResponse item : baseResponse) {
            ArrayList<NewUserRoleBindItem> roleBindItemList = item.getRoleBindItemList();
            if (ObjectUtil.isEmpty((Object)roleBindItemList)) {
                roleBindItemList = new ArrayList<NewUserRoleBindItem>();
                item.setRoleBindItemList(roleBindItemList);
            }
            for (SysRoleDTO businessRole : businessRoleList) {
                NewUserRoleBindItem newUserRoleBindItem = new NewUserRoleBindItem();
                newUserRoleBindItem.setRoleId(businessRole.getRoleId());
                newUserRoleBindItem.setRoleName(businessRole.getRoleName());
                newUserRoleBindItem.setRoleType(businessRole.getRoleType());
                newUserRoleBindItem.setCheckedFlag(Boolean.valueOf(false));
                roleBindItemList.add(newUserRoleBindItem);
            }
        }
        List companyRoleList = businessRoleAndCompanyRole.stream().filter(i -> i.getRoleType().equals(RoleTypeEnum.COMPANY_ROLE.getCode())).collect(Collectors.toList());
        for (SysRoleDTO companyRole : companyRoleList) {
            for (NewUserRoleBindResponse item : baseResponse) {
                if (!companyRole.getRoleCompanyId().equals(item.getCompanyId())) continue;
                List roleBindItemList = item.getRoleBindItemList();
                NewUserRoleBindItem newUserRoleBindItem = new NewUserRoleBindItem();
                newUserRoleBindItem.setRoleId(companyRole.getRoleId());
                newUserRoleBindItem.setRoleName(companyRole.getRoleName());
                newUserRoleBindItem.setRoleType(companyRole.getRoleType());
                newUserRoleBindItem.setCheckedFlag(Boolean.valueOf(false));
                roleBindItemList.add(newUserRoleBindItem);
            }
        }
    }

    public static List<NewUserRoleBindResponse> fillRoleBind(List<NewUserRoleBindResponse> baseResponse, List<UserRoleDTO> userLinkedOrgRoleList) {
        if (ObjectUtil.isEmpty(userLinkedOrgRoleList)) {
            return baseResponse;
        }
        for (NewUserRoleBindResponse item : baseResponse) {
            Long orgId = item.getOrgId();
            List roleBindItemList = item.getRoleBindItemList();
            for (UserRoleDTO userAlreadyBind : userLinkedOrgRoleList) {
                if (!userAlreadyBind.getRoleOrgId().equals(orgId)) continue;
                for (NewUserRoleBindItem newUserRoleBindItem : roleBindItemList) {
                    if (!newUserRoleBindItem.getRoleId().equals(userAlreadyBind.getRoleId())) continue;
                    newUserRoleBindItem.setCheckedFlag(Boolean.valueOf(true));
                }
            }
        }
        return baseResponse;
    }
}

