/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.user.controller;

import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.annotation.BizLog;
import cn.stylefeng.roses.kernel.rule.pojo.request.BaseRequest;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import cn.stylefeng.roses.kernel.sys.api.expander.SysConfigExpander;
import cn.stylefeng.roses.kernel.sys.modular.user.entity.SysUser;
import cn.stylefeng.roses.kernel.sys.modular.user.pojo.request.SysUserRequest;
import cn.stylefeng.roses.kernel.sys.modular.user.pojo.request.SysUserRoleRequest;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserRoleService;
import cn.stylefeng.roses.kernel.sys.modular.user.service.SysUserService;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="\u7cfb\u7edf\u7528\u6237")
public class SysUserController {
    @Resource
    private SysUserService sysUserService;
    @Resource
    private SysUserRoleService sysUserRoleService;

    @PostResource(name="\u6dfb\u52a0\u7528\u6237", path={"/sysUser/add"}, requiredPermission=true, requirePermissionCode="ADD_USER")
    @BizLog(logTypeCode="ADD_USER")
    public ResponseData<SysUser> add(@RequestBody @Validated(value={BaseRequest.add.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.add(sysUserRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u5220\u9664\u7528\u6237", path={"/sysUser/delete"}, requiredPermission=true, requirePermissionCode="DELETE_USER")
    @BizLog(logTypeCode="DELETE_USER")
    public ResponseData<?> delete(@RequestBody @Validated(value={BaseRequest.delete.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.del(sysUserRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u6279\u91cf\u5220\u9664\u7528\u6237", path={"/sysUser/batchDelete"}, requiredPermission=true, requirePermissionCode="DELETE_USER")
    @BizLog(logTypeCode="DELETE_USER")
    public ResponseData<?> batchDelete(@RequestBody @Validated(value={BaseRequest.batchDelete.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.batchDel(sysUserRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u7f16\u8f91\u7528\u6237", path={"/sysUser/edit"}, requiredPermission=true, requirePermissionCode="EDIT_USER")
    @BizLog(logTypeCode="EDIT_USER")
    public ResponseData<?> edit(@RequestBody @Validated(value={BaseRequest.edit.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.edit(sysUserRequest);
        return new SuccessResponseData();
    }

    @GetResource(name="\u67e5\u770b\u7528\u6237\u8be6\u60c5", path={"/sysUser/detail"})
    public ResponseData<SysUser> detail(@Validated(value={BaseRequest.detail.class}) SysUserRequest sysUserRequest) {
        return new SuccessResponseData((Object)this.sysUserService.detail(sysUserRequest));
    }

    @GetResource(name="\u5206\u9875\u67e5\u8be2-\u7528\u6237\u4fe1\u606f", path={"/sysUser/page"})
    public ResponseData<PageResult<SysUser>> page(SysUserRequest sysUserRequest) {
        return new SuccessResponseData(this.sysUserService.findPage(sysUserRequest));
    }

    @PostResource(name="\u4fee\u6539\u7528\u6237\u72b6\u6001", path={"/sysUser/updateStatus"}, requiredPermission=true, requirePermissionCode="UPDATE_USER_STATUS")
    @BizLog(logTypeCode="UPDATE_USER_STATUS")
    public ResponseData<?> updateStatus(@RequestBody @Validated(value={BaseRequest.updateStatus.class}) SysUserRequest sysUserRequest) {
        this.sysUserService.updateStatus(sysUserRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u7ed1\u5b9a\u7528\u6237\u89d2\u8272", path={"/sysUser/bindRoles"}, requiredPermission=true, requirePermissionCode="ASSIGN_USER_ROLE")
    @BizLog(logTypeCode="ASSIGN_USER_ROLE")
    public ResponseData<?> bindRoles(@RequestBody @Validated(value={SysUserRoleRequest.bindRoles.class}) SysUserRoleRequest sysUserRoleRequest) {
        this.sysUserRoleService.bindRoles(sysUserRoleRequest);
        return new SuccessResponseData();
    }

    @PostResource(name="\u91cd\u7f6e\u7528\u6237\u5bc6\u7801", path={"/sysUser/resetPassword"}, requiredPermission=true, requirePermissionCode="RESET_PASSWORD")
    @BizLog(logTypeCode="RESET_PASSWORD")
    public ResponseData<?> resetPassword(@RequestBody @Validated(value={SysUserRequest.resetPassword.class}) SysUserRequest sysUserRequest) {
        String password = SysConfigExpander.getDefaultPassWord();
        this.sysUserService.resetPassword(sysUserRequest.getUserId(), password);
        return new SuccessResponseData();
    }
}

