/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.stat.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.stat.api.callback.ClickCountCallback;
import cn.stylefeng.roses.kernel.stat.modular.entity.ClickCount;
import cn.stylefeng.roses.kernel.stat.modular.enums.ClickCountExceptionEnum;
import cn.stylefeng.roses.kernel.stat.modular.mapper.ClickCountMapper;
import cn.stylefeng.roses.kernel.stat.modular.request.ClickCountRequest;
import cn.stylefeng.roses.kernel.stat.modular.service.ClickCountService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ClickCountServiceImpl
extends ServiceImpl<ClickCountMapper, ClickCount>
implements ClickCountService {
    @Override
    public void add(ClickCountRequest portalClickCountRequest) {
        ClickCount portalClickCount = new ClickCount();
        BeanUtil.copyProperties((Object)((Object)portalClickCountRequest), (Object)((Object)portalClickCount), (String[])new String[0]);
        this.save((Object)portalClickCount);
    }

    @Override
    public void del(ClickCountRequest portalClickCountRequest) {
        ClickCount portalClickCount = this.queryPortalClickCount(portalClickCountRequest);
        this.removeById(portalClickCount.getClickCountId());
    }

    @Override
    public void edit(ClickCountRequest portalClickCountRequest) {
        ClickCount portalClickCount = this.queryPortalClickCount(portalClickCountRequest);
        BeanUtil.copyProperties((Object)((Object)portalClickCountRequest), (Object)((Object)portalClickCount), (String[])new String[0]);
        this.updateById((Object)portalClickCount);
    }

    @Override
    public ClickCount detail(ClickCountRequest portalClickCountRequest) {
        return this.queryPortalClickCount(portalClickCountRequest);
    }

    @Override
    public PageResult<ClickCount> findPage(ClickCountRequest portalClickCountRequest) {
        LambdaQueryWrapper<ClickCount> wrapper = this.createWrapper(portalClickCountRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public Long getBusinessCount(Long businessId) {
        LambdaQueryWrapper portalClickCountLambdaQueryWrapper = new LambdaQueryWrapper();
        portalClickCountLambdaQueryWrapper.eq(ClickCount::getBusinessKeyId, (Object)businessId);
        portalClickCountLambdaQueryWrapper.select(new SFunction[]{ClickCount::getClickCount});
        ClickCount one = (ClickCount)((Object)this.getOne((Wrapper)portalClickCountLambdaQueryWrapper, false));
        if (one != null) {
            return one.getClickCount();
        }
        return 0L;
    }

    @Override
    public List<ClickCount> findList(ClickCountRequest portalClickCountRequest) {
        LambdaQueryWrapper<ClickCount> wrapper = this.createWrapper(portalClickCountRequest);
        return this.list((Wrapper)wrapper);
    }

    public <T extends ClickCountCallback> void calcClickCount(List<T> clickCountCallbackList) {
        if (ObjectUtil.isEmpty(clickCountCallbackList)) {
            return;
        }
        for (ClickCountCallback clickCountCallback : clickCountCallbackList) {
            Long businessId = clickCountCallback.getBusinessId();
            Long clickCount = this.getBusinessCount(businessId);
            clickCountCallback.addClickCount(clickCount);
        }
    }

    public Long addOneClickCount(ClickCountCallback clickCountCallback) {
        LambdaQueryWrapper portalClickCountLambdaQueryWrapper = new LambdaQueryWrapper();
        portalClickCountLambdaQueryWrapper.eq(ClickCount::getBusinessKeyId, (Object)clickCountCallback.getBusinessId());
        ClickCount portalClickCount = (ClickCount)((Object)this.getOne((Wrapper)portalClickCountLambdaQueryWrapper, false));
        if (portalClickCount == null) {
            portalClickCount = new ClickCount();
            portalClickCount.setBusinessType(clickCountCallback.getBusinessTypeCode());
            portalClickCount.setBusinessKeyId(clickCountCallback.getBusinessId());
            portalClickCount.setClickCount(1L);
            this.save((Object)portalClickCount);
        } else {
            portalClickCount.setClickCount(portalClickCount.getClickCount() + 1L);
            this.updateById((Object)portalClickCount);
        }
        return portalClickCount.getClickCount();
    }

    private ClickCount queryPortalClickCount(ClickCountRequest portalClickCountRequest) {
        ClickCount portalClickCount = (ClickCount)((Object)this.getById(portalClickCountRequest.getClickCountId()));
        if (ObjectUtil.isEmpty((Object)((Object)portalClickCount))) {
            throw new ServiceException((AbstractExceptionEnum)ClickCountExceptionEnum.PORTAL_CLICK_COUNT_NOT_EXISTED);
        }
        return portalClickCount;
    }

    private LambdaQueryWrapper<ClickCount> createWrapper(ClickCountRequest portalClickCountRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long clickCountId = portalClickCountRequest.getClickCountId();
        String businessType = portalClickCountRequest.getBusinessType();
        Long businessKeyId = portalClickCountRequest.getBusinessKeyId();
        Long clickCount = portalClickCountRequest.getClickCount();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)clickCountId), ClickCount::getClickCountId, (Object)clickCountId);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)businessType), ClickCount::getBusinessType, (Object)businessType);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)businessKeyId), ClickCount::getBusinessKeyId, (Object)businessKeyId);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)clickCount), ClickCount::getClickCount, (Object)clickCount);
        return queryWrapper;
    }
}

