/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.starter;

import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.security.api.DragCaptchaApi;
import cn.stylefeng.roses.kernel.security.api.ImageCaptchaApi;
import cn.stylefeng.roses.kernel.security.captcha.DragCaptchaService;
import cn.stylefeng.roses.kernel.security.captcha.ImageCaptchaService;
import cn.stylefeng.roses.kernel.security.starter.cache.SecurityMemoryCacheAutoConfiguration;
import cn.stylefeng.roses.kernel.security.starter.cache.SecurityRedisCacheAutoConfiguration;
import jakarta.annotation.Resource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={SecurityMemoryCacheAutoConfiguration.class, SecurityRedisCacheAutoConfiguration.class})
public class CaptchaAutoConfiguration {
    @Resource(name="captchaCache")
    private CacheOperatorApi<String> captchaCache;

    @Bean
    @ConditionalOnMissingBean(value={ImageCaptchaApi.class})
    public ImageCaptchaApi captchaApi() {
        return new ImageCaptchaService(this.captchaCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={DragCaptchaApi.class})
    public DragCaptchaApi dragCaptchaService() {
        return new DragCaptchaService(this.captchaCache);
    }
}

