/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.captcha;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.security.api.ImageCaptchaApi;
import cn.stylefeng.roses.kernel.security.api.pojo.ImageCaptcha;
import com.wf.captcha.SpecCaptcha;

public class ImageCaptchaService
implements ImageCaptchaApi {
    private final CacheOperatorApi<String> cacheOperatorApi;

    public ImageCaptchaService(CacheOperatorApi<String> cacheOperatorApi) {
        this.cacheOperatorApi = cacheOperatorApi;
    }

    public ImageCaptcha captcha() {
        SpecCaptcha specCaptcha = new SpecCaptcha(130, 48, 5);
        String verCode = specCaptcha.text().toLowerCase();
        String verKey = IdUtil.simpleUUID();
        this.cacheOperatorApi.put(verKey, (Object)verCode, Long.valueOf(120L));
        return ImageCaptcha.builder().verImage(specCaptcha.toBase64()).verKey(verKey).build();
    }

    public boolean validateCaptcha(String verKey, String verCode) {
        if (StrUtil.isAllEmpty((CharSequence[])new CharSequence[]{verKey, verCode})) {
            return false;
        }
        if (!verCode.trim().toLowerCase().equals(this.cacheOperatorApi.get(verKey))) {
            return false;
        }
        this.cacheOperatorApi.remove(new String[]{verKey});
        return true;
    }

    public String getVerCode(String verKey) {
        return (String)this.cacheOperatorApi.get(verKey);
    }
}

