/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.blackwhite.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.rule.pojo.response.SuccessResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.ApiResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.GetResource;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import cn.stylefeng.roses.kernel.security.blackwhite.BlackListService;
import cn.stylefeng.roses.kernel.security.blackwhite.WhiteListService;
import cn.stylefeng.roses.kernel.security.blackwhite.pojo.BlackWhiteList;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ApiResource(name="\u9ed1\u767d\u540d\u5355\u63a5\u53e3", requiredPermission=true, requirePermissionCode="BLACK_WHITE_LIST_UPDATE")
public class SecurityBlackWhiteController {
    @Resource
    private BlackListService blackListService;
    @Resource
    private WhiteListService whiteListService;

    @GetResource(name="\u83b7\u53d6\u9ed1\u767d\u540d\u5355\u5217\u8868", path={"/blackWhite/list"})
    public ResponseData<BlackWhiteList> blackWhiteList() {
        BlackWhiteList blackWhiteList = new BlackWhiteList();
        Collection<String> blackList = this.blackListService.getBlackList();
        blackWhiteList.setBlackList(new ArrayList<String>(blackList));
        Collection<String> whiteList = this.whiteListService.getWhiteList();
        blackWhiteList.setWhiteList(new ArrayList<String>(whiteList));
        return new SuccessResponseData((Object)blackWhiteList);
    }

    @PostResource(name="\u8bbe\u7f6e\u9ed1\u767d\u540d\u5355\u5217\u8868", path={"/blackWhite/updateBlackWhite"})
    public ResponseData<?> updateBlackWhite(@RequestBody BlackWhiteList blackWhiteList) {
        Collection<String> whiteList;
        Collection<String> blackList = this.blackListService.getBlackList();
        if (ObjectUtil.isNotEmpty(blackList)) {
            for (String key : blackList) {
                this.blackListService.removeBlackItem(key);
            }
        }
        if (ObjectUtil.isNotEmpty(blackWhiteList.getBlackList())) {
            for (String key : blackWhiteList.getBlackList()) {
                this.blackListService.addBlackItem(key);
            }
        }
        if (ObjectUtil.isNotEmpty(whiteList = this.whiteListService.getWhiteList())) {
            for (String key : whiteList) {
                this.whiteListService.removeWhiteItem(key);
            }
        }
        if (ObjectUtil.isNotEmpty(blackWhiteList.getWhiteList())) {
            for (String key : blackWhiteList.getWhiteList()) {
                this.whiteListService.addWhiteItem(key);
            }
        }
        return new SuccessResponseData();
    }
}

