/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.blackwhite;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.security.blackwhite.BlackListService;
import cn.stylefeng.roses.kernel.security.blackwhite.WhiteListService;
import cn.stylefeng.roses.kernel.security.blackwhite.exception.BlackWhiteExceptionEnum;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BlackWhiteValidateService {
    @Resource
    private BlackListService blackListService;
    @Resource
    private WhiteListService whiteListService;

    public void totalValidate(String ip) {
        if (!this.validateBlackList(ip)) {
            throw new ServiceException((AbstractExceptionEnum)BlackWhiteExceptionEnum.IP_INVALID);
        }
        if (!this.validateWhiteList(ip)) {
            throw new ServiceException((AbstractExceptionEnum)BlackWhiteExceptionEnum.IP_INVALID);
        }
    }

    public boolean validateBlackList(String ip) {
        if (ObjectUtil.isEmpty(this.blackListService.getBlackList())) {
            return true;
        }
        return !this.blackListService.contains(ip);
    }

    public boolean validateWhiteList(String ip) {
        if (ObjectUtil.isEmpty(this.whiteListService.getWhiteList())) {
            return true;
        }
        return this.whiteListService.contains(ip);
    }
}

