/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.listener.ApplicationReadyListener;
import cn.stylefeng.roses.kernel.scanner.api.DevOpsDetectApi;
import cn.stylefeng.roses.kernel.scanner.api.DevOpsReportApi;
import cn.stylefeng.roses.kernel.scanner.api.ResourceCollectorApi;
import cn.stylefeng.roses.kernel.scanner.api.ResourceReportApi;
import cn.stylefeng.roses.kernel.scanner.api.constants.ScannerConstants;
import cn.stylefeng.roses.kernel.scanner.api.holder.InitScanFlagHolder;
import cn.stylefeng.roses.kernel.scanner.api.pojo.devops.DevOpsReportProperties;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ReportResourceParam;
import cn.stylefeng.roses.kernel.scanner.api.pojo.scanner.ScannerProperties;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;

public class ResourceReportListener
extends ApplicationReadyListener
implements Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceReportListener.class);

    public void eventCallback(ApplicationStartedEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        ScannerProperties scannerProperties = (ScannerProperties)applicationContext.getBean(ScannerProperties.class);
        if (!scannerProperties.getOpen().booleanValue()) {
            InitScanFlagHolder.setFlag();
            return;
        }
        if (!InitScanFlagHolder.getFlag().booleanValue()) {
            long beginSaveLocal = System.currentTimeMillis();
            ResourceCollectorApi resourceCollectorApi = (ResourceCollectorApi)applicationContext.getBean(ResourceCollectorApi.class);
            Map modularResources = resourceCollectorApi.getModularResources();
            ResourceReportApi resourceService = (ResourceReportApi)applicationContext.getBean(ResourceReportApi.class);
            List persistencePojos = resourceService.reportResourcesAndGetResult(new ReportResourceParam(scannerProperties.getAppCode(), modularResources));
            log.info("\u5b58\u50a8\u672c\u5730\u63a5\u53e3\u8d44\u6e90\u5b8c\u6210\uff0c\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - beginSaveLocal));
            DevOpsReportProperties devOpsReportProperties = (DevOpsReportProperties)applicationContext.getBean(DevOpsReportProperties.class);
            DevOpsDetectApi devOpsDetectApi = null;
            try {
                devOpsDetectApi = (DevOpsDetectApi)applicationContext.getBean(DevOpsDetectApi.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ObjectUtil.isNotEmpty((Object)devOpsReportProperties.getServerHost()) || devOpsDetectApi != null) {
                DevOpsReportApi devOpsReportApi = (DevOpsReportApi)applicationContext.getBean(DevOpsReportApi.class);
                CompletableFuture.runAsync(() -> {
                    long beginDevopsReport = System.currentTimeMillis();
                    devOpsReportApi.reportResources(devOpsReportProperties, persistencePojos);
                    log.info("\u5411DevOps\u5e73\u53f0\u6c47\u62a5\u8d44\u6e90\u4fe1\u606f\u5b8c\u6210\uff0c\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - beginDevopsReport));
                }).exceptionally(ex -> {
                    log.error("\u5411DevOps\u5e73\u53f0\u6c47\u62a5\u5f02\u5e38\u51fa\u73b0\u7f51\u7edc\u9519\u8bef\uff0c\u5982\u65e0\u6cd5\u8054\u901aDevOps\u5e73\u53f0\u53ef\u5173\u95ed\u76f8\u5173\u914d\u7f6e\u3002", ex);
                    return null;
                });
            }
            InitScanFlagHolder.setFlag();
        }
    }

    public int getOrder() {
        return ScannerConstants.REPORT_RESOURCE_LISTENER_SORT;
    }
}

