/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.api.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.stylefeng.roses.kernel.scanner.api.enums.ParamTypeEnum;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.ParameterMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;

public class MethodReflectUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MethodReflectUtil.class);

    public static List<Annotation> getMethodFirstParamAnnotations(Method method) {
        if (method == null) {
            return null;
        }
        if (method.getParameterCount() <= 0) {
            return null;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length == 0) {
            return null;
        }
        Object[] resultAnnotations = parameterAnnotations[0];
        if (resultAnnotations == null || resultAnnotations.length == 0) {
            return null;
        }
        return CollectionUtil.toList((Object[])resultAnnotations);
    }

    public static Set<String> getMethodValidateGroup(Method method) {
        List<Annotation> methodFirstParamAnnotations = MethodReflectUtil.getMethodFirstParamAnnotations(method);
        if (methodFirstParamAnnotations == null) {
            return null;
        }
        try {
            for (Annotation annotation : methodFirstParamAnnotations) {
                Method validateGroupMethod;
                Object invoke;
                if (!Validated.class.equals(annotation.annotationType()) || (invoke = (validateGroupMethod = annotation.annotationType().getMethod("value", new Class[0])).invoke((Object)annotation, new Object[0])) == null) continue;
                Class[] result = (Class[])invoke;
                HashSet<String> groupClassNames = new HashSet<String>();
                if (result.length > 0) {
                    for (Class groupClass : result) {
                        groupClassNames.add(groupClass.getSimpleName());
                    }
                } else {
                    groupClassNames.add("default-all");
                }
                return groupClassNames;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("\u83b7\u53d6\u65b9\u6cd5\u4e0a\u7684\u6821\u9a8c\u5206\u7ec4\u51fa\u9519\uff01", (Throwable)e);
        }
        return null;
    }

    public static Type[] getMethodGenericTypes(Method method) {
        if (method == null) {
            return null;
        }
        return method.getGenericParameterTypes();
    }

    public static Type getMethodReturnType(Method method) {
        if (method == null) {
            return null;
        }
        return method.getGenericReturnType();
    }

    public static List<ParameterMetadata> getMethodParameterInfos(Method method) {
        LinkedList<ParameterMetadata> result = new LinkedList<ParameterMetadata>();
        if (method == null) {
            return result;
        }
        Parameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return result;
        }
        for (Parameter parameter : parameters) {
            ParameterMetadata parameterMetadata = new ParameterMetadata();
            Type parameterizedType = parameter.getParameterizedType();
            parameterMetadata.setParameterizedType(parameterizedType);
            Annotation[] annotations = parameter.getAnnotations();
            parameterMetadata.setAnnotations(annotations);
            parameterMetadata.setParamTypeEnum(MethodReflectUtil.getParamTypeEnum(annotations));
            parameterMetadata.setParameterName(parameter.getName());
            result.add(parameterMetadata);
        }
        return result;
    }

    public static ParamTypeEnum getParamTypeEnum(Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return ParamTypeEnum.QUERY_PARAM;
        }
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(RequestBody.class)) continue;
            return ParamTypeEnum.REQUEST_BODY;
        }
        return ParamTypeEnum.QUERY_PARAM;
    }
}

