/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.api.factory;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.rule.annotation.ChineseDescription;
import cn.stylefeng.roses.kernel.rule.enums.FieldTypeEnum;
import cn.stylefeng.roses.kernel.rule.pojo.clazz.ClassParseResult;
import cn.stylefeng.roses.kernel.scanner.api.context.MetadataContext;
import cn.stylefeng.roses.kernel.scanner.api.enums.ParamTypeEnum;
import cn.stylefeng.roses.kernel.scanner.api.factory.AnnotationParseFactory;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.FieldMetadata;
import cn.stylefeng.roses.kernel.scanner.api.util.AdvancedClassTypeUtil;
import java.lang.reflect.Field;

public class MetadataCreateFactory {
    public static FieldMetadata createBaseClassMetadata(Class<?> clazz, FieldTypeEnum fieldTypeEnum, String uuid) {
        FieldMetadata fieldMetadataItem = new FieldMetadata();
        fieldMetadataItem.setMetadataId(IdUtil.fastSimpleUUID());
        fieldMetadataItem.setChineseName(clazz.getSimpleName());
        fieldMetadataItem.setFieldClassType(clazz.getSimpleName());
        fieldMetadataItem.setFieldClassPath(clazz.getName());
        String paramName = MetadataContext.getParamName(uuid);
        if (StrUtil.isNotBlank((CharSequence)paramName)) {
            fieldMetadataItem.setFieldName(paramName);
        }
        fieldMetadataItem.setFieldType(fieldTypeEnum.getCode());
        ParamTypeEnum paramTypeMetadata = MetadataContext.getParamTypeMetadata(uuid);
        if (paramTypeMetadata != null) {
            fieldMetadataItem.setRequestParamType(paramTypeMetadata.getCode());
        }
        return fieldMetadataItem;
    }

    public static FieldMetadata createBaseFieldMetadata(Field field, String uuid) {
        FieldMetadata fieldMetadataItem = new FieldMetadata();
        fieldMetadataItem.setMetadataId(IdUtil.fastSimpleUUID());
        ChineseDescription annotation = field.getAnnotation(ChineseDescription.class);
        if (annotation != null) {
            fieldMetadataItem.setChineseName(annotation.value());
        }
        Class<?> classType = field.getType();
        fieldMetadataItem.setFieldClassType(classType.getSimpleName());
        fieldMetadataItem.setFieldClassPath(classType.getName());
        fieldMetadataItem.setFieldName(field.getName());
        AnnotationParseFactory.parsingAnnotation(field, fieldMetadataItem);
        ClassParseResult classParseResult = AdvancedClassTypeUtil.getClassFieldType(field.getGenericType());
        fieldMetadataItem.setFieldType(classParseResult.getFieldTypeEnum().getCode());
        ParamTypeEnum paramTypeMetadata = MetadataContext.getParamTypeMetadata(uuid);
        if (paramTypeMetadata != null) {
            fieldMetadataItem.setRequestParamType(paramTypeMetadata.getCode());
        }
        return fieldMetadataItem;
    }
}

