/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.api.factory;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.rule.enums.FieldTypeEnum;
import cn.stylefeng.roses.kernel.rule.pojo.clazz.ClassParseResult;
import cn.stylefeng.roses.kernel.scanner.api.constants.ScannerConstants;
import cn.stylefeng.roses.kernel.scanner.api.context.MetadataContext;
import cn.stylefeng.roses.kernel.scanner.api.factory.ArrayMetadataFactory;
import cn.stylefeng.roses.kernel.scanner.api.factory.MetadataCreateFactory;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.FieldMetadata;
import cn.stylefeng.roses.kernel.scanner.api.pojo.resource.SubFieldMetadataDTO;
import cn.stylefeng.roses.kernel.scanner.api.util.AdvancedClassTypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassMetaFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassMetaFactory.class);

    public static FieldMetadata beginCreateFieldMetadata(Type type, String uuid) {
        ClassParseResult classParseResult = AdvancedClassTypeUtil.getClassFieldType(type);
        return ClassMetaFactory.beginCreateFieldMetadata(classParseResult, uuid);
    }

    public static FieldMetadata beginCreateFieldMetadata(ClassParseResult classParseResult, String uuid) {
        if (FieldTypeEnum.STRING.equals((Object)classParseResult.getFieldTypeEnum()) || FieldTypeEnum.NUMBER.equals((Object)classParseResult.getFieldTypeEnum())) {
            return MetadataCreateFactory.createBaseClassMetadata((Class)classParseResult.getOriginType(), classParseResult.getFieldTypeEnum(), uuid);
        }
        if (FieldTypeEnum.ARRAY.equals((Object)classParseResult.getFieldTypeEnum())) {
            return ClassMetaFactory.createArrayMetaDateResult(uuid, classParseResult);
        }
        if (FieldTypeEnum.COLLECTION.equals((Object)classParseResult.getFieldTypeEnum())) {
            return ClassMetaFactory.createArrayMetaDateResult(uuid, classParseResult);
        }
        if (FieldTypeEnum.OBJECT.equals((Object)classParseResult.getFieldTypeEnum())) {
            Class clazz = (Class)classParseResult.getOriginType();
            FieldMetadata currentClassMetaData = MetadataCreateFactory.createBaseClassMetadata(clazz, classParseResult.getFieldTypeEnum(), uuid);
            if (MetadataContext.ensureFieldClassHaveParse(uuid, clazz)) {
                return currentClassMetaData;
            }
            LinkedHashSet<FieldMetadata> totalFieldList = new LinkedHashSet<FieldMetadata>();
            ClassMetaFactory.processClassFields(clazz, totalFieldList, uuid);
            currentClassMetaData.setGenericFieldMetadata(totalFieldList);
            return currentClassMetaData;
        }
        if (FieldTypeEnum.OBJECT_WITH_GENERIC.equals((Object)classParseResult.getFieldTypeEnum())) {
            Class rawTypeClass = classParseResult.getRawTypeClass();
            FieldMetadata rawTypeMetadata = ClassMetaFactory.beginCreateFieldMetadata(rawTypeClass, uuid);
            Set<FieldMetadata> genericFieldMetadata = rawTypeMetadata.getGenericFieldMetadata();
            if (ObjectUtil.isEmpty(genericFieldMetadata)) {
                return rawTypeMetadata;
            }
            for (FieldMetadata subField : genericFieldMetadata) {
                if (FieldTypeEnum.WITH_UNKNOWN_OBJ_GENERIC.getCode().equals(subField.getFieldType())) {
                    Type subFieldGenericType = classParseResult.getGenericType();
                    ClassMetaFactory.getGenericObjFieldTypeAndFillOriginMeta(uuid, subField, subFieldGenericType);
                }
                if (!FieldTypeEnum.WITH_UNKNOWN_ARRAY_GENERIC.getCode().equals(subField.getFieldType())) continue;
                Type arrayRealGenericType = classParseResult.getGenericType();
                ClassMetaFactory.getGenericListFieldTypeAndFillOriginMeta(uuid, subField, arrayRealGenericType);
            }
            return rawTypeMetadata;
        }
        if (FieldTypeEnum.MAP.equals((Object)classParseResult.getFieldTypeEnum())) {
            return MetadataCreateFactory.createBaseClassMetadata(Map.class, FieldTypeEnum.MAP, uuid);
        }
        return MetadataCreateFactory.createBaseClassMetadata(String.class, FieldTypeEnum.STRING, uuid);
    }

    private static FieldMetadata createArrayMetaDateResult(String uuid, ClassParseResult classParseResult) {
        FieldMetadata arrayItemMetadata = MetadataCreateFactory.createBaseClassMetadata(List.class, FieldTypeEnum.COLLECTION, uuid);
        Type genericType = classParseResult.getGenericType();
        FieldMetadata arrayFieldMetadata = ClassMetaFactory.beginCreateFieldMetadata(genericType, uuid);
        ArrayMetadataFactory.fillArrayItemFieldMetaData(arrayFieldMetadata);
        arrayItemMetadata.setArrayFieldMetadata(arrayFieldMetadata);
        return arrayItemMetadata;
    }

    private static void processClassFields(Class<?> clazz, Set<FieldMetadata> fieldMetadata, String uuid) {
        Field[] fields;
        if (clazz == null || Object.class.equals(clazz)) {
            return;
        }
        MetadataContext.addClassRecord(uuid, clazz.getName());
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (ScannerConstants.DONT_PARSE_FIELD.contains(field.getName())) continue;
            FieldMetadata fieldInfo = MetadataCreateFactory.createBaseFieldMetadata(field, uuid);
            Type genericType = field.getGenericType();
            SubFieldMetadataDTO typeSubInfo = ClassMetaFactory.getTypeSubInfo(uuid, genericType);
            fieldInfo.setGenericFieldMetadata(typeSubInfo.getGenericFieldMetadata());
            ArrayMetadataFactory.fillArrayItemFieldMetaData(typeSubInfo.getArrayFieldMetadata());
            fieldInfo.setArrayFieldMetadata(typeSubInfo.getArrayFieldMetadata());
            fieldMetadata.add(fieldInfo);
        }
        ClassMetaFactory.processClassFields(clazz.getSuperclass(), fieldMetadata, uuid);
    }

    public static SubFieldMetadataDTO getTypeSubInfo(String uuid, Type type) {
        FieldMetadata arrayFieldMetadata;
        SubFieldMetadataDTO fieldInfo = new SubFieldMetadataDTO();
        FieldMetadata validateFieldHaveSubInfo = ClassMetaFactory.beginCreateFieldMetadata(type, uuid);
        Set<FieldMetadata> genericFieldMetadata = validateFieldHaveSubInfo.getGenericFieldMetadata();
        if (ObjectUtil.isNotEmpty(genericFieldMetadata)) {
            fieldInfo.setGenericFieldMetadata(genericFieldMetadata);
        }
        if (ObjectUtil.isNotEmpty((Object)(arrayFieldMetadata = validateFieldHaveSubInfo.getArrayFieldMetadata()))) {
            fieldInfo.setArrayFieldMetadata(arrayFieldMetadata);
        }
        return fieldInfo;
    }

    private static void getGenericObjFieldTypeAndFillOriginMeta(String uuid, FieldMetadata subField, Type subFieldType) {
        FieldMetadata realSubFieldMetadata = ClassMetaFactory.beginCreateFieldMetadata(subFieldType, uuid);
        subField.setFieldClassType(realSubFieldMetadata.getFieldClassType());
        subField.setFieldClassPath(realSubFieldMetadata.getFieldClassPath());
        subField.setFieldType(realSubFieldMetadata.getFieldType());
        subField.setGenericFieldMetadata(realSubFieldMetadata.getGenericFieldMetadata());
        ArrayMetadataFactory.fillArrayItemFieldMetaData(realSubFieldMetadata.getArrayFieldMetadata());
        subField.setArrayFieldMetadata(realSubFieldMetadata.getArrayFieldMetadata());
    }

    private static void getGenericListFieldTypeAndFillOriginMeta(String uuid, FieldMetadata subField, Type arrayRealGenericType) {
        ClassParseResult arrayRealGenericTypeResult = new ClassParseResult(FieldTypeEnum.ARRAY, arrayRealGenericType);
        FieldMetadata fieldMetadata = ClassMetaFactory.beginCreateFieldMetadata(arrayRealGenericTypeResult, uuid);
        subField.setFieldType(FieldTypeEnum.ARRAY.getCode());
        ArrayMetadataFactory.fillArrayItemFieldMetaData(fieldMetadata.getArrayFieldMetadata());
        subField.setArrayFieldMetadata(fieldMetadata.getArrayFieldMetadata());
    }
}

