/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.business.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.log.api.BizLogServiceApi;
import cn.stylefeng.roses.kernel.log.api.pojo.business.SysLogBusinessRequest;
import cn.stylefeng.roses.kernel.log.api.pojo.entity.SysLogBusiness;
import cn.stylefeng.roses.kernel.log.api.pojo.entity.SysLogBusinessContent;
import cn.stylefeng.roses.kernel.log.business.enums.SysLogBusinessExceptionEnum;
import cn.stylefeng.roses.kernel.log.business.mapper.SysLogBusinessMapper;
import cn.stylefeng.roses.kernel.log.business.service.SysLogBusinessContentService;
import cn.stylefeng.roses.kernel.log.business.service.SysLogBusinessService;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysLogBusinessServiceImpl
extends ServiceImpl<SysLogBusinessMapper, SysLogBusiness>
implements SysLogBusinessService,
BizLogServiceApi {
    @Resource
    private SysLogBusinessContentService sysLogBusinessContentService;

    @Override
    public void add(SysLogBusinessRequest sysLogBusinessRequest) {
        SysLogBusiness sysLogBusiness = new SysLogBusiness();
        BeanUtil.copyProperties((Object)sysLogBusinessRequest, (Object)sysLogBusiness, (String[])new String[0]);
        this.save(sysLogBusiness);
    }

    @Override
    public void del(SysLogBusinessRequest sysLogBusinessRequest) {
        SysLogBusiness sysLogBusiness = this.querySysLogBusiness(sysLogBusinessRequest);
        this.removeById(sysLogBusiness.getBusinessLogId());
    }

    @Override
    public void edit(SysLogBusinessRequest sysLogBusinessRequest) {
        SysLogBusiness sysLogBusiness = this.querySysLogBusiness(sysLogBusinessRequest);
        BeanUtil.copyProperties((Object)sysLogBusinessRequest, (Object)sysLogBusiness, (String[])new String[0]);
        this.updateById(sysLogBusiness);
    }

    @Override
    public SysLogBusiness detail(SysLogBusinessRequest sysLogBusinessRequest) {
        return this.querySysLogBusiness(sysLogBusinessRequest);
    }

    @Override
    public PageResult<SysLogBusiness> findPage(SysLogBusinessRequest sysLogBusinessRequest) {
        LambdaQueryWrapper<SysLogBusiness> wrapper = this.createWrapper(sysLogBusinessRequest);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public void saveBatchLogs(SysLogBusiness context, List<String> batchContentList) {
        if (ObjectUtil.isEmpty(batchContentList)) {
            return;
        }
        this.save(context);
        ArrayList<SysLogBusinessContent> sysLogBusinessContentList = new ArrayList<SysLogBusinessContent>();
        for (String content : batchContentList) {
            SysLogBusinessContent sysLogBusinessContent = new SysLogBusinessContent();
            sysLogBusinessContent.setBusinessLogId(context.getBusinessLogId());
            sysLogBusinessContent.setLogContent(content);
            sysLogBusinessContentList.add(sysLogBusinessContent);
        }
        this.sysLogBusinessContentService.batchSaveContent(sysLogBusinessContentList);
    }

    @Override
    public List<SysLogBusiness> findList(SysLogBusinessRequest sysLogBusinessRequest) {
        LambdaQueryWrapper<SysLogBusiness> wrapper = this.createWrapper(sysLogBusinessRequest);
        return this.list((Wrapper)wrapper);
    }

    /*
     * Enabled aggressive block sorting
     */
    public PageResult<SysLogBusiness> getOperateLogByLogType(List<String> logTypeCodeList, SysLogBusinessRequest sysLogBusinessRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ObjectUtil.isEmpty(logTypeCodeList)) {
            Page page = PageFactory.defaultPage();
            return PageResultFactory.createPageResult((Page)page);
        }
        String logTypeCode = sysLogBusinessRequest.getLogTypeCode();
        if (StrUtil.isNotBlank((CharSequence)logTypeCode)) {
            if (!logTypeCodeList.contains(logTypeCode)) {
                Page page = PageFactory.defaultPage();
                return PageResultFactory.createPageResult((Page)page);
            }
            queryWrapper.eq(SysLogBusiness::getLogTypeCode, (Object)logTypeCode);
        } else {
            queryWrapper.in(SysLogBusiness::getLogTypeCode, logTypeCodeList);
        }
        this.buildCommonWrapper(sysLogBusinessRequest, (LambdaQueryWrapper<SysLogBusiness>)queryWrapper);
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)queryWrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    private SysLogBusiness querySysLogBusiness(SysLogBusinessRequest sysLogBusinessRequest) {
        SysLogBusiness sysLogBusiness = (SysLogBusiness)this.getById(sysLogBusinessRequest.getBusinessLogId());
        if (ObjectUtil.isEmpty((Object)sysLogBusiness)) {
            throw new ServiceException((AbstractExceptionEnum)SysLogBusinessExceptionEnum.SYS_LOG_BUSINESS_NOT_EXISTED);
        }
        return sysLogBusiness;
    }

    private LambdaQueryWrapper<SysLogBusiness> createWrapper(SysLogBusinessRequest sysLogBusinessRequest) {
        Long userId;
        String clientIp;
        String httpMethod;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String logTypeCode = sysLogBusinessRequest.getLogTypeCode();
        if (StrUtil.isNotBlank((CharSequence)logTypeCode)) {
            queryWrapper.like(SysLogBusiness::getLogTypeCode, (Object)logTypeCode);
        }
        if (StrUtil.isNotBlank((CharSequence)(httpMethod = sysLogBusinessRequest.getHttpMethod()))) {
            queryWrapper.eq(SysLogBusiness::getHttpMethod, (Object)httpMethod);
        }
        if (StrUtil.isNotBlank((CharSequence)(clientIp = sysLogBusinessRequest.getClientIp()))) {
            queryWrapper.likeRight(SysLogBusiness::getClientIp, (Object)clientIp);
        }
        if (ObjectUtil.isNotEmpty((Object)(userId = sysLogBusinessRequest.getUserId()))) {
            queryWrapper.eq(SysLogBusiness::getUserId, (Object)userId);
        }
        String searchBeginTime = sysLogBusinessRequest.getSearchBeginTime();
        String searchEndTime = sysLogBusinessRequest.getSearchEndTime();
        if (StrUtil.isNotBlank((CharSequence)searchBeginTime) && StrUtil.isNotBlank((CharSequence)searchEndTime)) {
            queryWrapper.between(BaseEntity::getCreateTime, (Object)(searchBeginTime + " 00:00:00"), (Object)(searchEndTime + " 23:59:59"));
        }
        this.buildCommonWrapper(sysLogBusinessRequest, (LambdaQueryWrapper<SysLogBusiness>)queryWrapper);
        return queryWrapper;
    }

    private void buildCommonWrapper(SysLogBusinessRequest sysLogBusinessRequest, LambdaQueryWrapper<SysLogBusiness> queryWrapper) {
        String searchText = sysLogBusinessRequest.getSearchText();
        if (ObjectUtil.isNotEmpty((Object)searchText)) {
            queryWrapper.nested(wrap -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrap.like(SysLogBusiness::getLogTitle, (Object)searchText)).or()).like(SysLogBusiness::getRequestUrl, (Object)searchText));
        }
        if (ObjectUtil.isNotEmpty((Object)sysLogBusinessRequest.getOrderBy()) && ObjectUtil.isNotEmpty((Object)sysLogBusinessRequest.getSortBy())) {
            queryWrapper.last(sysLogBusinessRequest.getOrderByLastSql());
        } else {
            queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        }
    }
}

