/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.security.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.log.api.pojo.security.LogSecurityRequest;
import cn.stylefeng.roses.kernel.log.security.entity.LogSecurity;
import cn.stylefeng.roses.kernel.log.security.enums.LogSecurityExceptionEnum;
import cn.stylefeng.roses.kernel.log.security.mapper.LogSecurityMapper;
import cn.stylefeng.roses.kernel.log.security.service.LogSecurityService;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.security.api.CountValidatorApi;
import cn.stylefeng.roses.kernel.security.api.exception.CountValidateException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogSecurityServiceImpl
extends ServiceImpl<LogSecurityMapper, LogSecurity>
implements LogSecurityService {
    @Resource
    private CountValidatorApi countValidatorApi;

    public void add(LogSecurityRequest logSecurityRequest) {
        try {
            this.countValidatorApi.countAndValidate("SEC_LOG_" + logSecurityRequest.getClientIp(), Long.valueOf(3600L), Long.valueOf(100L));
            LogSecurity logSecurity = new LogSecurity();
            BeanUtil.copyProperties((Object)logSecurityRequest, (Object)((Object)logSecurity), (String[])new String[0]);
            this.save((Object)logSecurity);
        }
        catch (CountValidateException countValidateException) {
            // empty catch block
        }
    }

    @Override
    public void del(LogSecurityRequest logSecurityRequest) {
        LogSecurity logSecurity = this.queryLogSecurity(logSecurityRequest);
        this.removeById(logSecurity.getSecurityLogId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(LogSecurityRequest logSecurityRequest) {
        this.removeByIds(logSecurityRequest.getBatchDeleteIdList());
    }

    @Override
    public void edit(LogSecurityRequest logSecurityRequest) {
        LogSecurity logSecurity = this.queryLogSecurity(logSecurityRequest);
        BeanUtil.copyProperties((Object)logSecurityRequest, (Object)((Object)logSecurity), (String[])new String[0]);
        this.updateById((Object)logSecurity);
    }

    @Override
    public LogSecurity detail(LogSecurityRequest logSecurityRequest) {
        return this.queryLogSecurity(logSecurityRequest);
    }

    @Override
    public PageResult<LogSecurity> findPage(LogSecurityRequest logSecurityRequest) {
        LambdaQueryWrapper<LogSecurity> wrapper = this.createWrapper(logSecurityRequest);
        Page pageList = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)pageList);
    }

    @Override
    public List<LogSecurity> findList(LogSecurityRequest logSecurityRequest) {
        LambdaQueryWrapper<LogSecurity> wrapper = this.createWrapper(logSecurityRequest);
        return this.list((Wrapper)wrapper);
    }

    private LogSecurity queryLogSecurity(LogSecurityRequest logSecurityRequest) {
        LogSecurity logSecurity = (LogSecurity)((Object)this.getById(logSecurityRequest.getSecurityLogId()));
        if (ObjectUtil.isEmpty((Object)((Object)logSecurity))) {
            throw new ServiceException((AbstractExceptionEnum)LogSecurityExceptionEnum.LOG_SECURITY_NOT_EXISTED);
        }
        return logSecurity;
    }

    private LambdaQueryWrapper<LogSecurity> createWrapper(LogSecurityRequest logSecurityRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String requestUrl = logSecurityRequest.getRequestUrl();
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)requestUrl), LogSecurity::getRequestUrl, (Object)requestUrl);
        String clientIp = logSecurityRequest.getClientIp();
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)clientIp), LogSecurity::getClientIp, (Object)clientIp);
        String httpMethod = logSecurityRequest.getHttpMethod();
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)httpMethod), LogSecurity::getHttpMethod, (Object)httpMethod);
        String logContent = logSecurityRequest.getLogContent();
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)logContent), LogSecurity::getLogContent, (Object)logContent);
        String searchBeginTime = logSecurityRequest.getSearchBeginTime();
        String searchEndTime = logSecurityRequest.getSearchEndTime();
        if (StrUtil.isNotBlank((CharSequence)searchBeginTime) && StrUtil.isNotBlank((CharSequence)searchEndTime)) {
            queryWrapper.between(BaseEntity::getCreateTime, (Object)(searchBeginTime + " 00:00:00"), (Object)(searchEndTime + " 23:59:59"));
        }
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        return queryWrapper;
    }
}

