/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.loginlog.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.log.api.LoginLogServiceApi;
import cn.stylefeng.roses.kernel.log.api.exception.LogException;
import cn.stylefeng.roses.kernel.log.api.exception.enums.LogExceptionEnum;
import cn.stylefeng.roses.kernel.log.api.pojo.loginlog.SysLoginLogRequest;
import cn.stylefeng.roses.kernel.log.loginlog.entity.SysLoginLog;
import cn.stylefeng.roses.kernel.log.loginlog.mapper.SysLoginLogMapper;
import cn.stylefeng.roses.kernel.log.loginlog.service.SysLoginLogService;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import cn.stylefeng.roses.kernel.sys.api.SysUserServiceApi;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service
public class SysLoginLogServiceImpl
extends ServiceImpl<SysLoginLogMapper, SysLoginLog>
implements SysLoginLogService,
LoginLogServiceApi {
    @Resource
    private SysUserServiceApi sysUserServiceApi;

    @Override
    public void del(SysLoginLogRequest sysLoginLogRequest) {
        SysLoginLog sysLoginLog = this.querySysLoginLogById(sysLoginLogRequest);
        this.removeById(sysLoginLog.getLlgId());
    }

    @Override
    public SysLoginLog detail(SysLoginLogRequest sysLoginLogRequest) {
        LambdaQueryWrapper<SysLoginLog> queryWrapper = this.createWrapper(sysLoginLogRequest);
        return (SysLoginLog)this.getOne((Wrapper)queryWrapper, false);
    }

    @Override
    public PageResult<SysLoginLog> findPage(SysLoginLogRequest sysLoginLogRequest) {
        LambdaQueryWrapper<SysLoginLog> wrapper = this.createWrapper(sysLoginLogRequest);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    public void add(SysLoginLogRequest sysLoginLogRequest) {
        SysLoginLog sysLoginLog = new SysLoginLog();
        BeanUtil.copyProperties((Object)sysLoginLogRequest, (Object)sysLoginLog, (String[])new String[0]);
        this.save(sysLoginLog);
    }

    public void loginSuccess(Long userId, String account) {
        SysLoginLog sysLoginLog = new SysLoginLog();
        sysLoginLog.setLlgName("\u767b\u5f55\u65e5\u5fd7");
        sysLoginLog.setUserId(userId);
        sysLoginLog.setAccount(account);
        sysLoginLog.setLlgIpAddress(HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest()));
        sysLoginLog.setLlgSucceed("\u6210\u529f");
        sysLoginLog.setLlgMessage("\u7cfb\u7edf\u767b\u5f55\u6210\u529f\uff01");
        this.save(sysLoginLog);
    }

    public void loginFail(String account, String ip) {
        SysLoginLog sysLoginLog = new SysLoginLog();
        sysLoginLog.setLlgName("\u767b\u5f55\u65e5\u5fd7");
        sysLoginLog.setLlgSucceed("\u5931\u8d25");
        sysLoginLog.setLlgMessage("\u7cfb\u7edf\u767b\u5f55\u5931\u8d25\uff01");
        sysLoginLog.setLlgIpAddress(ip);
        sysLoginLog.setAccount(account);
        this.save(sysLoginLog);
    }

    public void loginOutSuccess(Long userId) {
        SysLoginLog sysLoginLog = new SysLoginLog();
        sysLoginLog.setLlgName("\u9000\u51fa\u65e5\u5fd7");
        sysLoginLog.setUserId(userId);
        sysLoginLog.setLlgIpAddress(HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest()));
        sysLoginLog.setLlgSucceed("\u6210\u529f");
        sysLoginLog.setLlgMessage("\u7cfb\u7edf\u9000\u51fa\u6210\u529f\uff01");
        this.save(sysLoginLog);
    }

    public void loginOutFail(Long userId) {
        SysLoginLog sysLoginLog = new SysLoginLog();
        sysLoginLog.setLlgName("\u9000\u51fa\u65e5\u5fd7");
        sysLoginLog.setUserId(userId);
        sysLoginLog.setLlgIpAddress(HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest()));
        sysLoginLog.setLlgSucceed("\u5931\u8d25");
        sysLoginLog.setLlgMessage("\u7cfb\u7edf\u9000\u51fa\u5931\u8d25\uff01");
        this.save(sysLoginLog);
    }

    @Override
    public void delAll() {
        this.remove(null);
    }

    private SysLoginLog querySysLoginLogById(SysLoginLogRequest sysLoginLogRequest) {
        SysLoginLog sysLoginLog = (SysLoginLog)this.getById(sysLoginLogRequest.getLlgId());
        if (ObjectUtil.isNull((Object)sysLoginLog)) {
            throw new LogException((AbstractExceptionEnum)LogExceptionEnum.LOG_NOT_EXISTED, new Object[]{sysLoginLogRequest.getLlgId()});
        }
        return sysLoginLog;
    }

    private LambdaQueryWrapper<SysLoginLog> createWrapper(SysLoginLogRequest sysLoginLogRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (ObjectUtil.isEmpty((Object)sysLoginLogRequest)) {
            return queryWrapper;
        }
        Date beginTime = sysLoginLogRequest.getBeginTime();
        Date endTime = sysLoginLogRequest.getEndTime();
        if (ObjectUtil.isNotEmpty((Object)beginTime) && ObjectUtil.isNotEmpty((Object)endTime)) {
            queryWrapper.between(SysLoginLog::getCreateTime, (Object)(beginTime + " 00:00:00"), (Object)(endTime + " 23:59:59"));
        }
        if (StrUtil.isNotBlank((CharSequence)sysLoginLogRequest.getLlgName())) {
            queryWrapper.eq(SysLoginLog::getLlgName, (Object)sysLoginLogRequest.getLlgName());
        }
        if (ObjectUtil.isNotEmpty((Object)sysLoginLogRequest.getUserId())) {
            queryWrapper.eq(SysLoginLog::getUserId, (Object)sysLoginLogRequest.getUserId());
        }
        if (ObjectUtil.isNotEmpty((Object)sysLoginLogRequest.getOrderBy()) && ObjectUtil.isNotEmpty((Object)sysLoginLogRequest.getSortBy())) {
            queryWrapper.last(sysLoginLogRequest.getOrderByLastSql());
        } else {
            queryWrapper.orderByDesc(SysLoginLog::getCreateTime);
        }
        return queryWrapper;
    }
}

