/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.rule.util;

import cn.hutool.core.util.ClassUtil;
import cn.stylefeng.roses.kernel.rule.enums.FieldTypeEnum;
import cn.stylefeng.roses.kernel.rule.pojo.clazz.ClassParseResult;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassTypeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassTypeUtil.class);

    public static ClassParseResult getClassFieldType(Type type) {
        if (type == null) {
            return new ClassParseResult(FieldTypeEnum.OTHER, null);
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (ClassTypeUtil.validateNumericTypeFlag(clazz)) {
                return new ClassParseResult(FieldTypeEnum.NUMBER, null);
            }
            if (ClassUtil.isSimpleValueType((Class)clazz)) {
                return new ClassParseResult(FieldTypeEnum.STRING, null);
            }
            if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                return new ClassParseResult(FieldTypeEnum.ARRAY, componentType);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new ClassParseResult(FieldTypeEnum.COLLECTION, null);
            }
            if (Object.class.isAssignableFrom(clazz)) {
                return new ClassParseResult(FieldTypeEnum.OBJECT, null);
            }
            log.debug("\u7c7b\u578b\u662fClass\uff0c\u4f46\u6709\u5904\u7406\u4e0d\u5230\u7684\u60c5\u51b5\uff0c\u6253\u5370\u51fa\u7c7b\u7684\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)clazz.toGenericString());
            return new ClassParseResult(FieldTypeEnum.OTHER, null);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawTypeClass = (Class)parameterizedType.getRawType();
            Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
            if (Collection.class.isAssignableFrom(rawTypeClass)) {
                return new ClassParseResult(FieldTypeEnum.COLLECTION, actualTypeArgument);
            }
            if (Map.class.isAssignableFrom(rawTypeClass)) {
                return new ClassParseResult(FieldTypeEnum.STRING, null);
            }
            if (Object.class.isAssignableFrom(rawTypeClass)) {
                return new ClassParseResult(FieldTypeEnum.OBJECT_WITH_GENERIC, actualTypeArgument);
            }
            log.debug("\u6cdb\u578b\u7684\u4e3b\u4f53\u60c5\u51b5\u4e0d\u786e\u5b9a\uff0c\u4e0d\u5904\u7406\uff0c\u6253\u5370\u51farawTypeClass\uff1a{}", (Object)rawTypeClass.getName());
            return new ClassParseResult(FieldTypeEnum.OTHER, null);
        }
        if (type.getTypeName().equals("T")) {
            return new ClassParseResult(FieldTypeEnum.WITH_UNKNOWN_OBJ_GENERIC, null);
        }
        log.debug("\u672a\u77e5\u7c7b\u578b\u7684\u5904\u7406\uff0c\u65e2\u4e0d\u662fclass\u4e5f\u4e0d\u662fParameterizedType\uff0c\u6253\u5370\u51fa\u7c7b\u7684\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)type.getTypeName());
        return new ClassParseResult(FieldTypeEnum.OTHER, null);
    }

    public static boolean validateNumericTypeFlag(Class<?> clazz) {
        if (clazz == Long.class || clazz == Long.TYPE) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Float.TYPE || clazz == Double.TYPE;
        }
        return Number.class.isAssignableFrom(clazz);
    }
}

